/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.CanonizerBaseValue;
import com.actelion.research.chem.CanonizerBond;
import com.actelion.research.chem.CanonizerFragment;
import com.actelion.research.chem.CanonizerMesoHelper;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.EZHalfParity;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SortedStringList;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Canonizer {
    public static final int CREATE_SYMMETRY_RANK = 1;
    public static final int CONSIDER_STEREOHETEROTOPICITY = 2;
    public static final int ENCODE_ATOM_CUSTOM_LABELS = 8;
    public static final int ENCODE_ATOM_SELECTION = 16;
    public static final int ASSIGN_PARITIES_TO_TETRAHEDRAL_N = 32;
    public static final int COORDS_ARE_3D = 64;
    public static final int CREATE_PSEUDO_STEREO_GROUPS = 128;
    public static final int DISTINGUISH_RACEMIC_OR_GROUPS = 256;
    public static final int TIE_BREAK_FREE_VALENCE_ATOMS = 512;
    public static final int ENCODE_ATOM_CUSTOM_LABELS_WITHOUT_RANKING = 1024;
    public static final int NEGLECT_ANY_STEREO_INFORMATION = 2048;
    protected static final int cIDCodeVersion2 = 8;
    protected static final int cIDCodeVersion3 = 9;
    public static final int cIDCodeCurrentVersion = 9;
    protected static final int cParity1And = 4;
    protected static final int cParity2And = 5;
    protected static final int cParity1Or = 6;
    protected static final int cParity2Or = 7;
    private static final int CALC_PARITY_MODE_PARITY = 1;
    private static final int CALC_PARITY_MODE_PRO_PARITY = 2;
    private static final int CALC_PARITY_MODE_IN_SAME_FRAGMENT = 3;
    private StereoMolecule mMol;
    private int[] mCanRank;
    private int[] mCanRankBeforeTieBreaking;
    private int[] mPseudoTHGroup;
    private int[] mPseudoEZGroup;
    private byte[] mTHParity;
    private byte[] mEZParity;
    private byte[] mTHConfiguration;
    private byte[] mEZConfiguration;
    private byte[] mTHCIPParity;
    private byte[] mEZCIPParity;
    private byte[] mTHESRType;
    private byte[] mTHESRGroup;
    private byte[] mEZESRType;
    private byte[] mEZESRGroup;
    private byte[] mAbnormalValence;
    private CanonizerBaseValue[] mCanBase;
    private CanonizerMesoHelper mMesoHelper;
    private boolean mIsMeso;
    private boolean mStereoCentersFound;
    private boolean[] mIsStereoCenter;
    private boolean[] mTHParityIsMesoInverted;
    private boolean[] mTHParityNeedsNormalization;
    private boolean[] mTHESRTypeNeedsNormalization;
    private boolean[] mTHParityRoundIsOdd;
    private boolean[] mEZParityRoundIsOdd;
    private boolean[] mTHParityIsPseudo;
    private boolean[] mEZParityIsPseudo;
    private boolean[] mProTHAtomsInSameFragment;
    private boolean[] mProEZAtomsInSameFragment;
    private boolean[] mNitrogenQualifiesForParity;
    private ArrayList<CanonizerFragment> mFragmentList;
    private ArrayList<int[]> mTHParityNormalizationGroupList;
    private int mMode;
    private int mNoOfRanks;
    private int mNoOfPseudoGroups;
    private boolean mIsOddParityRound;
    private boolean mZCoordinatesAvailable;
    private boolean mCIPParityNoDistinctionProblem;
    private boolean mEncodeAvoid127;
    private boolean mGraphGenerated;
    private int mGraphRings;
    private int mFeatureBlock;
    private int[] mGraphAtom;
    private int[] mGraphIndex;
    private int[] mGraphBond;
    private int[] mGraphFrom;
    private int[] mGraphClosure;
    private String mIDCode;
    private String mEncodedCoords;
    private String mMapping;
    private StringBuilder mEncodingBuffer;
    private int mEncodingBitsAvail;
    private int mEncodingTempData;
    private int mAtomBits;
    private int mMaxConnAtoms;

    public Canonizer(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 0);
    }

    public Canonizer(StereoMolecule stereoMolecule, int n) {
        this.mMol = stereoMolecule;
        this.mMode = n;
        this.mMol.ensureHelperArrays(7);
        this.mAtomBits = Canonizer.getNeededBits(this.mMol.getAtoms());
        if ((this.mMode & 0x800) == 0) {
            this.canFindNitrogenQualifyingForParity();
        }
        boolean bl = this.mZCoordinatesAvailable = (n & 0x40) != 0 || this.mMol.is3D();
        if ((this.mMode & 0x800) == 0) {
            this.mTHParity = new byte[this.mMol.getAtoms()];
            this.mTHParityIsPseudo = new boolean[this.mMol.getAtoms()];
            this.mTHParityRoundIsOdd = new boolean[this.mMol.getAtoms()];
            this.mEZParity = new byte[this.mMol.getBonds()];
            this.mEZParityRoundIsOdd = new boolean[this.mMol.getBonds()];
            this.mEZParityIsPseudo = new boolean[this.mMol.getBonds()];
        }
        this.mCIPParityNoDistinctionProblem = false;
        this.canInitializeRanking();
        if ((this.mMode & 0x800) == 0) {
            this.canRankStereo();
        }
        this.canRankFinal();
    }

    public boolean hasCIPParityDistinctionProblem() {
        return this.mCIPParityNoDistinctionProblem;
    }

    private void canFindNitrogenQualifyingForParity() {
        this.mNitrogenQualifiesForParity = new boolean[this.mMol.getAtoms()];
        block6: for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            if (this.mMol.getAtomicNo(i) != 7) continue;
            if (this.mMol.getConnAtoms(i) == 4) {
                this.mNitrogenQualifiesForParity[i] = true;
                continue;
            }
            if (this.mMol.getConnAtoms(i) != 3) continue;
            if (this.mMol.getAtomRingSize(i) == 3) {
                this.mNitrogenQualifiesForParity[i] = true;
                continue;
            }
            if (this.mMol.getAtomCharge(i) == 1) {
                this.mNitrogenQualifiesForParity[i] = true;
                continue;
            }
            if (this.mMol.isFlatNitrogen(i)) continue;
            if ((this.mMode & 0x20) != 0) {
                this.mNitrogenQualifiesForParity[i] = true;
                continue;
            }
            if (this.mMol.getAtomRingBondCount(i) != 3 || (n2 = this.mMol.getAtomRingSize(i)) > 7) continue;
            RingCollection ringCollection = this.mMol.getRingSet();
            for (n = 0; !(n >= ringCollection.getSize() || ringCollection.getRingSize(n) == n2 && ringCollection.isAtomMember(n, i)); ++n) {
            }
            if (n >= 1024 && n == ringCollection.getSize()) continue;
            int n3 = -1;
            int n4 = -1;
            for (int j = 0; j < 3; ++j) {
                int n5 = this.mMol.getConnBond(i, j);
                if (ringCollection.isBondMember(n, n5)) continue;
                n3 = this.mMol.getConnAtom(i, j);
                n4 = n5;
                break;
            }
            boolean[] blArray = new boolean[this.mMol.getBonds()];
            blArray[n4] = true;
            int[] nArray = new int[11];
            int n6 = this.mMol.getPath(nArray, n3, i, 10, blArray);
            if (n6 == -1) continue;
            int n7 = 1;
            while (!ringCollection.isAtomMember(n, nArray[n7])) {
                ++n7;
            }
            int n8 = n6 - n7;
            int n9 = nArray[n7];
            if (n2 == 6 && n8 == 2 && n7 == 3 && this.mMol.getAtomRingBondCount(nArray[1]) >= 3) {
                bl2 = false;
                int[] nArray2 = ringCollection.getRingAtoms(n);
                for (int j = 0; j < 6; ++j) {
                    if (i != nArray2[j]) continue;
                    int n10 = ringCollection.validateMemberIndex(n, n9 == nArray2[ringCollection.validateMemberIndex(n, j + 2)] ? j - 2 : j + 2);
                    int n11 = nArray2[n10];
                    if (this.mMol.getAtomRingBondCount(n11) < 3 || this.mMol.getPathLength(nArray[1], n11, 2, null) != 2) break;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    this.mNitrogenQualifiesForParity[i] = true;
                    continue;
                }
            }
            bl2 = this.mMol.getAtomPi(n9) == 1 || this.mMol.isAromaticAtom(n9) || this.mMol.isFlatNitrogen(n9);
            boolean bl3 = bl = !bl2 && this.mMol.getAtomicNo(n9) == 7 && this.mMol.getAtomCharge(n9) != 1;
            if (n8 == 1) {
                if (bl2 || bl || n2 > 4 || n7 > 3) continue;
                this.mNitrogenQualifiesForParity[i] = true;
                continue;
            }
            switch (n2) {
                case 4: {
                    if (bl2 || bl || n7 > 4) continue block6;
                    this.mNitrogenQualifiesForParity[i] = true;
                    continue block6;
                }
                case 5: {
                    if (bl) {
                        if (n7 > 3) continue block6;
                        this.mNitrogenQualifiesForParity[i] = true;
                        continue block6;
                    }
                    if (bl2 || n7 > 4) continue block6;
                    this.mNitrogenQualifiesForParity[i] = true;
                    continue block6;
                }
                case 6: {
                    if (n8 == 2) {
                        if (bl2) {
                            if (n7 > 4) continue block6;
                            this.mNitrogenQualifiesForParity[i] = true;
                            continue block6;
                        }
                        if (bl || n7 > 3) continue block6;
                        this.mNitrogenQualifiesForParity[i] = true;
                        continue block6;
                    }
                    if (n8 != 3) continue block6;
                    if (bl2) {
                        if (n7 > 6) continue block6;
                        this.mNitrogenQualifiesForParity[i] = true;
                        continue block6;
                    }
                    if (n7 > 4) continue block6;
                    this.mNitrogenQualifiesForParity[i] = true;
                    continue block6;
                }
                case 7: {
                    if (n8 != 3 || n7 > 3) continue block6;
                    this.mNitrogenQualifiesForParity[i] = true;
                }
            }
        }
    }

    private int canCalcImplicitAbnormalValence(int n) {
        int n2 = this.mMol.getAtomAbnormalValence(n);
        int n3 = this.mMol.getImplicitHigherValence(n, false);
        int n4 = this.mMol.getImplicitHigherValence(n, true);
        int n5 = -1;
        if (n3 != n4) {
            n5 = n2 != -1 && n2 > n3 ? (int)((byte)n2) : (int)((byte)n3);
        } else if (n2 != -1) {
            if (n2 > n4 || n2 < n4 && n2 >= this.mMol.getOccupiedValence(n)) {
                n5 = (byte)n2;
            }
        } else if (!this.mMol.supportsImplicitHydrogen(n) && this.mMol.getExplicitHydrogens(n) != 0) {
            n5 = this.mMol.getOccupiedValence(n);
            n5 -= this.mMol.getElectronValenceCorrection(n, n5);
        }
        this.canSetAbnormalValence(n, n5);
        return n5;
    }

    private void canSetAbnormalValence(int n, int n2) {
        if (this.mAbnormalValence == null) {
            this.mAbnormalValence = new byte[this.mMol.getAtoms()];
            Arrays.fill(this.mAbnormalValence, (byte)-1);
        }
        this.mAbnormalValence[n] = (byte)n2;
    }

    private void canRankStereo() {
        int n;
        int n2 = this.mNoOfRanks;
        int[] nArray = Arrays.copyOf(this.mCanRank, this.mMol.getAtoms());
        if (!this.mMol.isFragment()) {
            this.canRecursivelyFindCIPParities();
            this.initializeParities(n2, nArray);
        }
        this.mTHESRType = new byte[this.mMol.getAtoms()];
        this.mTHESRGroup = new byte[this.mMol.getAtoms()];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            this.mTHESRType[n] = (byte)this.mMol.getAtomESRType(n);
            this.mTHESRGroup[n] = (byte)this.mMol.getAtomESRGroup(n);
        }
        this.mEZESRType = new byte[this.mMol.getBonds()];
        this.mEZESRGroup = new byte[this.mMol.getBonds()];
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            this.mEZESRType[n] = (byte)this.mMol.getBondESRType(n);
            this.mEZESRGroup[n] = (byte)this.mMol.getBondESRGroup(n);
        }
        this.canRecursivelyFindAllParities();
        this.mStereoCentersFound = false;
        this.mIsStereoCenter = new boolean[this.mMol.getAtoms()];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mTHParity[n] == 0) continue;
            this.mIsStereoCenter[n] = true;
            this.mStereoCentersFound = true;
        }
        this.canRemoveOverspecifiedESRGroups();
        this.mMesoHelper = null;
        this.mTHESRTypeNeedsNormalization = new boolean[this.mMol.getAtoms()];
        if (this.mStereoCentersFound) {
            this.mMesoHelper = new CanonizerMesoHelper(this.mMol, nArray, this.mIsStereoCenter, this.mTHParity, this.mEZParity, this.mTHESRType, this.mTHESRGroup, this.mEZESRType, this.mEZESRGroup, this.mTHParityRoundIsOdd, this.mEZParityRoundIsOdd, this.mTHESRTypeNeedsNormalization);
            this.mMesoHelper.normalizeESRGroups();
        }
        this.mTHParityIsMesoInverted = new boolean[this.mMol.getAtoms()];
        this.mTHParityNeedsNormalization = new boolean[this.mMol.getAtoms()];
        this.mTHParityNormalizationGroupList = new ArrayList();
        if (this.mMesoHelper != null) {
            this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
        }
        this.canMarkESRGroupsForParityNormalization();
        this.initializeParities(n2, nArray);
        this.canRecursivelyFindCanonizedParities();
        if (this.mMesoHelper != null) {
            this.mIsMeso = this.mMesoHelper.isMeso();
        }
        this.determineChirality(nArray);
    }

    private void canRankFinal() {
        if ((this.mMode & 1) != 0 && (this.mMode & 2) == 0) {
            this.mCanRankBeforeTieBreaking = Arrays.copyOf(this.mCanRank, this.mMol.getAtoms());
        }
        if ((this.mMode & 0x800) == 0) {
            this.mProTHAtomsInSameFragment = new boolean[this.mMol.getAtoms()];
            this.mProEZAtomsInSameFragment = new boolean[this.mMol.getBonds()];
            if (this.mNoOfRanks < this.mMol.getAtoms()) {
                this.canBreakTiesByHeteroTopicity();
                if ((this.mMode & 0x800) == 0) {
                    this.canNormalizeGroupParities();
                    if (this.mMesoHelper != null) {
                        this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
                    }
                }
            }
        }
        if (this.mCanRankBeforeTieBreaking == null && (this.mMode & 1) != 0 && (this.mMode & 2) != 0) {
            this.mCanRankBeforeTieBreaking = Arrays.copyOf(this.mCanRank, this.mMol.getAtoms());
        }
        while (this.mNoOfRanks < this.mMol.getAtoms()) {
            this.canBreakTiesRandomly();
            if ((this.mMode & 0x800) != 0) continue;
            this.canNormalizeGroupParities();
            if (this.mMesoHelper == null) continue;
            this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
        }
        if ((this.mMode & 0x800) == 0) {
            this.canNormalizeGroupParities();
            this.canFindPseudoParities();
            this.flagStereoProblems();
        }
    }

    private boolean canBreakTiesByHeteroTopicity() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            this.mCanBase[n2].init(n2);
            this.mCanBase[n2].add(2 * this.mAtomBits + 4, (long)this.mCanRank[n2] << this.mAtomBits + 4);
        }
        n2 = 0;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            n2 |= this.canCalcTHParity(n, 3);
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            n2 |= this.canCalcEZParity(n, 3);
        }
        if (n2 == 0) {
            return false;
        }
        while (this.mNoOfRanks < this.mMol.getAtoms() && (n2 = (int)(this.canInnerBreakTiesByHeteroTopicity() ? 1 : 0)) != 0) {
            this.canNormalizeGroupParities();
            if (this.mMesoHelper == null) continue;
            this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank);
        }
        return true;
    }

    private boolean canInnerBreakTiesByHeteroTopicity() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            this.mCanBase[n4].init(n4);
            this.mCanBase[n4].add(2 * this.mAtomBits + 4, (long)this.mCanRank[n4] << this.mAtomBits + 4);
        }
        for (n4 = 1; n4 <= this.mNoOfRanks; ++n4) {
            n3 = 0;
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                if (this.mCanRank[n2] != n4) continue;
                n3 |= this.canCalcTHParity(n2, 2);
            }
            if (n3 == 0) continue;
            n2 = this.mNoOfRanks;
            this.mNoOfRanks = this.canPerformRanking();
            if (this.mNoOfRanks != n2) {
                return true;
            }
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                this.mCanBase[n].init(n);
                this.mCanBase[n].add(2 * this.mAtomBits + 4, (long)this.mCanRank[n] << this.mAtomBits + 4);
            }
        }
        Object[] objectArray = new CanonizerBond[this.mMol.getBonds()];
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            objectArray[n3] = new CanonizerBond(this.mCanRank[this.mMol.getBondAtom(0, n3)], this.mCanRank[this.mMol.getBondAtom(1, n3)], n3);
        }
        Arrays.sort(objectArray);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            if (!this.canCalcEZParity(((CanonizerBond)objectArray[n3]).bond, 2)) continue;
            while (n3 + 1 < objectArray.length && ((CanonizerBond)objectArray[n3]).compareTo((CanonizerBond)objectArray[n3 + 1]) == 0) {
                this.canCalcEZParity(((CanonizerBond)objectArray[++n3]).bond, 2);
            }
            n2 = this.mNoOfRanks;
            this.mNoOfRanks = this.canPerformRanking();
            if (this.mNoOfRanks != n2) {
                return true;
            }
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                this.mCanBase[n].init(n);
                this.mCanBase[n].add(2 * this.mAtomBits + 4, (long)this.mCanRank[n] << this.mAtomBits + 4);
            }
        }
        return false;
    }

    private void canBreakTiesRandomly() {
        int n;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            this.mCanBase[i].init(i);
            this.mCanBase[i].add(this.mAtomBits + 1, 2 * this.mCanRank[i]);
        }
        int[] nArray = new int[this.mNoOfRanks + 1];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            int n2 = this.mCanRank[n];
            nArray[n2] = nArray[n2] + 1;
        }
        n = 1;
        while (nArray[n] == 1) {
            ++n;
        }
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mCanRank[i] != n) continue;
            this.mCanBase[i].add(1L);
            break;
        }
        this.mNoOfRanks = this.canPerformRanking();
    }

    private void initializeParities(int n, int[] nArray) {
        int n2;
        this.mNoOfRanks = n;
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            this.mCanRank[n2] = nArray[n2];
            this.mTHParity[n2] = 0;
            this.mTHParityRoundIsOdd[n2] = false;
        }
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            this.mEZParity[n2] = 0;
            this.mEZParityRoundIsOdd[n2] = false;
        }
    }

    private void canInitializeRanking() {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        if (this.mMol.isFragment()) {
            for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
                if (this.mMol.getBondQueryFeatures(n5) == 0) continue;
                bl = true;
                break;
            }
        }
        this.mMaxConnAtoms = 2;
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            this.mMaxConnAtoms = Math.max(this.mMaxConnAtoms, this.mMol.getConnAtoms(n5) + this.mMol.getMetalBondedConnAtoms(n5));
        }
        n5 = Math.max(2, bl ? (62 + this.mAtomBits + this.mMaxConnAtoms * (this.mAtomBits + 23)) / 63 : (62 + this.mAtomBits + this.mMaxConnAtoms * (this.mAtomBits + 5)) / 63);
        this.mCanRank = new int[this.mMol.getAllAtoms()];
        this.mCanBase = new CanonizerBaseValue[this.mMol.getAtoms()];
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            this.mCanBase[n4] = new CanonizerBaseValue(n5);
        }
        n4 = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            this.mCanBase[n3].init(n3);
            if ((this.mMol.getAtomQueryFeatures(n3) & 1L) != 0L || this.mMol.getAtomList(n3) != null) {
                this.mCanBase[n3].add(8, 6L);
            } else {
                this.mCanBase[n3].add(8, this.mMol.getAtomicNo(n3));
            }
            this.mCanBase[n3].add(8, this.mMol.getAtomMass(n3));
            this.mCanBase[n3].add(2, this.mMol.getAtomPi(n3));
            this.mCanBase[n3].add(4, this.mMol.getConnAtoms(n3) + this.mMol.getMetalBondedConnAtoms(n3));
            if ((this.mMol.getAtomQueryFeatures(n3) & 1L) != 0L) {
                this.mCanBase[n3].add(4, 8L);
            } else {
                this.mCanBase[n3].add(4, 8 + this.mMol.getAtomCharge(n3));
            }
            this.mCanBase[n3].add(5, Math.min(31, this.mMol.getAtomRingSize(n3)));
            this.mCanBase[n3].add(4, this.canCalcImplicitAbnormalValence(n3) + 1);
            this.mCanBase[n3].add(2, this.mMol.getAtomRadical(n3) >> 4);
            if (!this.mMol.isFragment()) continue;
            this.mCanBase[n3].add(46, this.mMol.getAtomQueryFeatures(n3));
            if (this.mMol.getAtomList(n3) == null) continue;
            n4 = 1;
        }
        this.mNoOfRanks = this.canPerformRanking();
        if (this.mNoOfRanks < this.mMol.getAtoms()) {
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                this.mCanBase[n3].init(n3);
                this.mCanBase[n3].add(this.mAtomBits, this.mCanRank[n3]);
                objectArray = new int[this.mMol.getConnAtoms(n3)];
                for (n2 = 0; n2 < this.mMol.getConnAtoms(n3); ++n2) {
                    objectArray[n2] = this.mCanRank[this.mMol.getConnAtom(n3, n2)] << 5;
                    int n6 = n2;
                    objectArray[n6] = objectArray[n6] | Math.min(31, this.mMol.getBondRingSize(this.mMol.getConnBond(n3, n2)));
                }
                Arrays.sort(objectArray);
                for (n2 = this.mMaxConnAtoms; n2 > objectArray.length; --n2) {
                    this.mCanBase[n3].add(this.mAtomBits + 5, 0L);
                }
                for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                    this.mCanBase[n3].add(this.mAtomBits + 5, objectArray[n2]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if (n4 != 0 && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                this.mCanBase[n3].init(n3);
                this.mCanBase[n3].add(this.mAtomBits, this.mCanRank[n3]);
                objectArray = this.mMol.getAtomList(n3);
                n2 = objectArray == null ? 0 : Math.min(12, objectArray.length);
                for (n = 12; n > n2; --n) {
                    this.mCanBase[n3].add(8, 0L);
                }
                for (n = n2 - 1; n >= 0; --n) {
                    this.mCanBase[n3].add(8, objectArray[n]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if (bl && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                this.mCanBase[n3].init(n3);
                this.mCanBase[n3].add(this.mAtomBits, this.mCanRank[n3]);
                objectArray = new long[this.mMol.getConnAtoms(n3) + this.mMol.getMetalBondedConnAtoms(n3)];
                n2 = 0;
                for (n = 0; n < this.mMol.getAllConnAtomsPlusMetalBonds(n3); ++n) {
                    if (n >= this.mMol.getConnAtoms(n3) && n < this.mMol.getAllConnAtoms(n3)) continue;
                    objectArray[n2] = (int)((long)this.mCanRank[this.mMol.getConnAtom(n3, n)]);
                    int n7 = n2;
                    objectArray[n7] = objectArray[n7] << 23;
                    int n8 = n2++;
                    objectArray[n8] = objectArray[n8] | (long)this.mMol.getBondQueryFeatures(this.mMol.getConnBond(n3, n));
                }
                Arrays.sort((long[])objectArray);
                for (n = this.mMaxConnAtoms; n > objectArray.length; --n) {
                    this.mCanBase[n3].add(this.mAtomBits + 23, 0L);
                }
                for (n = objectArray.length - 1; n >= 0; --n) {
                    this.mCanBase[n3].add(this.mAtomBits + 23, objectArray[n]);
                }
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 8) != 0 && this.mNoOfRanks < this.mMol.getAtoms()) {
            int n9;
            SortedStringList sortedStringList = new SortedStringList();
            for (n9 = 0; n9 < this.mMol.getAtoms(); ++n9) {
                if (this.mMol.getAtomCustomLabel(n9) == null) continue;
                sortedStringList.addString(this.mMol.getAtomCustomLabel(n9));
            }
            for (n9 = 0; n9 < this.mMol.getAtoms(); ++n9) {
                n2 = this.mMol.getAtomCustomLabel(n9) == null ? 0 : 1 + sortedStringList.getListIndex(this.mMol.getAtomCustomLabel(n9));
                this.mCanBase[n9].init(n9);
                this.mCanBase[n9].add(this.mAtomBits, this.mCanRank[n9]);
                this.mCanBase[n9].add(this.mAtomBits, n2);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 0x10) != 0 && this.mNoOfRanks < this.mMol.getAtoms()) {
            for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                this.mCanBase[i].init(i);
                this.mCanBase[i].add(this.mAtomBits, this.mCanRank[i]);
                this.mCanBase[i].add(1, this.mMol.isSelectedAtom(i) ? 1L : 0L);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
        if ((this.mMode & 0x200) != 0 && this.mMol.isFragment()) {
            this.canBreakFreeValenceAtomTies();
        }
    }

    private void canBreakFreeValenceAtomTies() {
        while (true) {
            int n;
            boolean[] blArray = new boolean[this.mNoOfRanks + 1];
            int n2 = -1;
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                if (this.mMol.getLowestFreeValence(n) == 0) continue;
                if (blArray[this.mCanRank[n]] && n2 < this.mCanRank[n]) {
                    n2 = this.mCanRank[n];
                }
                blArray[this.mCanRank[n]] = true;
            }
            if (n2 == -1) break;
            n = 0;
            for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                int n3 = 0;
                if (this.mCanRank[i] == n2) {
                    n3 = ++n;
                }
                this.mCanBase[i].init(i);
                this.mCanBase[i].add(this.mAtomBits, this.mCanRank[i]);
                this.mCanBase[i].add(8, n3);
            }
            this.mNoOfRanks = this.canPerformRanking();
        }
    }

    private void canRemoveOverspecifiedESRGroups() {
        int n;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mIsStereoCenter[n] && this.mTHParity[n] != 3) continue;
            this.mTHESRType[n] = 0;
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(n) == 1 && this.mEZParity[n] != 0 && this.mEZParity[n] != 3) continue;
            this.mEZESRType[n] = 0;
        }
    }

    private void canRecursivelyFindAllParities() {
        this.mIsOddParityRound = true;
        boolean bl = this.canFindParities(false);
        while (this.mNoOfRanks < this.mMol.getAtoms() && bl) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                this.mCanBase[n2].init(n2);
                this.mCanBase[n2].add(this.mAtomBits, this.mCanRank[n2]);
                n = this.mTHParity[n2] << 7;
                if ((this.mTHParity[n2] == 1 || this.mTHParity[n2] == 2) && this.mTHESRType[n2] != 0) {
                    n |= this.mTHESRType[n2] << 5;
                    n |= this.mTHESRGroup[n2];
                }
                this.mCanBase[n2].add(18, n << 9);
            }
            for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
                n = this.mEZParity[n2] << 7;
                if ((this.mEZParity[n2] == 1 || this.mEZParity[n2] == 2) && this.mMol.getBondType(n2) == 1 && this.mEZESRType[n2] != 0) {
                    n |= this.mEZESRType[n2] << 5;
                    n |= this.mEZESRGroup[n2];
                }
                this.mCanBase[this.mMol.getBondAtom(0, n2)].add(n);
                this.mCanBase[this.mMol.getBondAtom(1, n2)].add(n);
            }
            n2 = this.canPerformRanking();
            if (this.mNoOfRanks == n2) break;
            this.mNoOfRanks = n2;
            bl = this.canFindParities(false);
        }
    }

    private void canRecursivelyFindCIPParities() {
        this.mIsOddParityRound = true;
        this.mTHCIPParity = new byte[this.mMol.getAtoms()];
        this.mEZCIPParity = new byte[this.mMol.getBonds()];
        boolean bl = this.canFindParities(true);
        while (this.mNoOfRanks < this.mMol.getAtoms() && bl) {
            int n;
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                this.mCanBase[n].init(n);
                this.mCanBase[n].add(this.mAtomBits + 4, this.mCanRank[n] << 4 | this.mTHParity[n] << 2);
            }
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                this.mCanBase[this.mMol.getBondAtom(0, n)].add(this.mEZParity[n]);
                this.mCanBase[this.mMol.getBondAtom(1, n)].add(this.mEZParity[n]);
            }
            n = this.canPerformRanking();
            if (this.mNoOfRanks == n) break;
            this.mNoOfRanks = n;
            bl = this.canFindParities(true);
        }
    }

    private void canRecursivelyFindCanonizedParities() {
        this.mIsOddParityRound = true;
        int[][][] nArray = this.compileESRGroupMembers();
        if (this.mMesoHelper != null && this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank)) {
            nArray = this.compileESRGroupMembers();
        }
        if (this.canFindParities(false)) {
            this.canNormalizeGroupParities();
        }
        boolean bl = true;
        while (this.mNoOfRanks < this.mMol.getAtoms() && bl) {
            int n;
            int[][] nArray2 = this.canGetESRGroupRank(nArray);
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                this.mCanBase[n].init(n);
                this.mCanBase[n].add(this.mAtomBits, this.mCanRank[n]);
                this.mCanBase[n].add(20, 0L);
                if (!this.mTHESRTypeNeedsNormalization[n] && this.mTHESRType[n] != 0) {
                    this.mCanBase[n].add((this.mTHESRType[n] << 18) + (nArray2[this.mTHESRType[n] == 1 ? 0 : 1][this.mTHESRGroup[n]] << 8));
                }
                int n2 = this.mTHParity[n];
                if (this.mTHParityIsMesoInverted[n]) {
                    if (n2 == 1) {
                        n2 = 2;
                    } else if (n2 == 2) {
                        n2 = 1;
                    }
                }
                this.mCanBase[n].add(n2 << 4);
            }
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                this.mCanBase[this.mMol.getBondAtom(0, n)].add(this.mEZParity[n]);
                this.mCanBase[this.mMol.getBondAtom(1, n)].add(this.mEZParity[n]);
            }
            n = this.canPerformRanking();
            if (this.mNoOfRanks == n) break;
            this.mNoOfRanks = n;
            bl = false;
            if (this.mMesoHelper != null && this.mMesoHelper.normalizeESRGroupSwappingAndRemoval(this.mCanRank)) {
                bl = true;
                nArray = this.compileESRGroupMembers();
            }
            if (!this.canFindParities(false)) continue;
            bl = true;
            this.canNormalizeGroupParities();
        }
    }

    private int[][][] compileESRGroupMembers() {
        int[][][] nArray = new int[2][32][];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.mIsStereoCenter[i]) continue;
            if (this.mTHESRType[i] == 1) {
                nArray[0][this.mTHESRGroup[i]] = CanonizerMesoHelper.addToIntArray(nArray[0][this.mTHESRGroup[i]], i);
                continue;
            }
            if (this.mTHESRType[i] != 2) continue;
            nArray[1][this.mTHESRGroup[i]] = CanonizerMesoHelper.addToIntArray(nArray[0][this.mTHESRGroup[i]], i);
        }
        return nArray;
    }

    private boolean canNormalizeGroupParities() {
        boolean bl = false;
        for (int i = 0; i < this.mTHParityNormalizationGroupList.size(); ++i) {
            int[] nArray = this.mTHParityNormalizationGroupList.get(i);
            boolean bl2 = true;
            int n = -1;
            boolean bl3 = false;
            for (int j = 0; j < nArray.length; ++j) {
                int n2 = nArray[j];
                if (this.mTHParity[n2] == 0) {
                    bl2 = false;
                    break;
                }
                if (this.mTHParity[n2] == 3) continue;
                int n3 = 1;
                for (int k = 0; k < nArray.length; ++k) {
                    if (k == j || this.mCanRank[n2] != this.mCanRank[nArray[k]]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0 || n >= this.mCanRank[n2]) continue;
                n = this.mCanRank[n2];
                bl3 = this.mTHParity[n2] == 1;
            }
            if (!bl2 || n == -1) continue;
            for (int k : nArray) {
                if (this.mTHParity[k] == 1 || this.mTHParity[k] == 2) {
                    this.mTHParityIsMesoInverted[k] = bl3;
                }
                this.mTHParityNeedsNormalization[k] = false;
            }
            this.mTHParityNormalizationGroupList.remove(nArray);
            bl = true;
            --i;
        }
        return bl;
    }

    private void canMarkESRGroupsForParityNormalization() {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mTHESRType[i] == 0 || this.mTHESRType[i] == 2 && (this.mMode & 0x100) != 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mTHESRType[n] == 0 || this.mTHESRType[n] == 2 && (this.mMode & 0x100) != 0) continue;
            nArray[n2] = this.mTHESRType[n] << 29 | this.mTHESRGroup[n] << 24 | this.mCanRank[n] << 12 | n;
            ++n2;
        }
        Arrays.sort(nArray);
        n = 0;
        int n3 = 0;
        int n4 = nArray[0] & 0xFF000000;
        while (true) {
            if (++n3 != nArray.length && n4 == (nArray[n3] & 0xFF000000)) {
                continue;
            }
            int[] nArray2 = new int[n3 - n];
            for (int i = n; i < n3; ++i) {
                int n5;
                nArray2[i - n] = n5 = nArray[i] & 0xFFF;
                this.mTHParityNeedsNormalization[n5] = true;
            }
            this.mTHParityNormalizationGroupList.add(nArray2);
            if (n3 == nArray.length) break;
            n4 = nArray[n3] & 0xFF000000;
            n = n3;
        }
    }

    private int[][] canGetESRGroupRank(int[][][] nArray) {
        int[][] nArray2 = new int[2][32];
        for (int i = 0; i < 2; ++i) {
            int n;
            int n2;
            int[][] nArrayArray = new int[32][];
            int n3 = 0;
            for (n2 = 0; n2 < 32; ++n2) {
                if (nArray[i][n2] == null) continue;
                n = nArray[i][n2].length;
                nArrayArray[n2] = new int[n];
                for (int j = 0; j < n; ++j) {
                    nArrayArray[n2][j] = this.mCanRank[nArray[i][n2][j]];
                }
                Arrays.sort(nArrayArray[n2]);
                ++n3;
            }
            n2 = n3;
            while (n2 > 0) {
                n = 0;
                int[] nArray3 = null;
                block4: for (int j = 0; j < 32; ++j) {
                    if (nArrayArray[j] == null) continue;
                    if (nArray3 == null || nArray3.length < nArrayArray[j].length) {
                        nArray3 = nArrayArray[j];
                        n = j;
                        continue;
                    }
                    if (nArray3.length != nArrayArray[j].length) continue;
                    for (int k = nArray3.length - 1; k >= 0; --k) {
                        if (nArray3[k] >= nArrayArray[j][k]) continue;
                        nArray3 = nArrayArray[j];
                        n = j;
                        continue block4;
                    }
                }
                nArray2[i][n] = n2--;
                nArrayArray[n] = null;
            }
        }
        return nArray2;
    }

    private boolean canFindParities(boolean bl) {
        int n;
        boolean bl2 = false;
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (!this.canCalcEZParity(n, 1)) continue;
            this.mEZParityRoundIsOdd[n] = this.mIsOddParityRound;
            if (bl) {
                this.cipCalcEZParity(n);
            }
            bl2 = true;
        }
        n = 0;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.canCalcTHParity(i, 1)) continue;
            this.mTHParityRoundIsOdd[i] = this.mIsOddParityRound;
            if (bl) {
                this.cipCalcTHParity(i);
            }
            n = 1;
        }
        if (n != 0) {
            this.mIsOddParityRound = !this.mIsOddParityRound;
        }
        return bl2 || n != 0;
    }

    private void determineChirality(int[] nArray) {
        byte by;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        boolean[] blArray = new boolean[32];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mTHParity[n] == 0) continue;
            ++n2;
            if (this.mTHParity[n] == 3) {
                ++n3;
                continue;
            }
            if (this.mTHESRType[n] == 0) {
                ++n4;
                if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(n)) continue;
                ++n5;
                continue;
            }
            if (this.mTHESRType[n] == 2) {
                if (this.mTHESRGroup[n] != 0) continue;
                ++n7;
                continue;
            }
            if (this.mTHESRType[n] != 1) continue;
            by = this.mTHESRGroup[n];
            if (!blArray[by]) {
                ++n8;
                blArray[by] = true;
            }
            if (this.mTHESRGroup[n] == 0) {
                ++n6;
            }
            if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(n)) continue;
            bl = true;
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mEZParity[n] == 0 || this.mMol.getBondType(n) != 1) continue;
            ++n2;
            if (this.mEZParity[n] == 3) {
                ++n3;
                continue;
            }
            if (this.mEZESRType[n] == 0) {
                ++n4;
                if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(0, n)) || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(1, n))) continue;
                ++n5;
                continue;
            }
            if (this.mEZESRType[n] == 2) {
                if (this.mEZESRGroup[n] != 0) continue;
                ++n7;
                continue;
            }
            if (this.mEZESRType[n] != 1) continue;
            by = this.mEZESRGroup[n];
            if (!blArray[by]) {
                ++n8;
                blArray[by] = true;
            }
            if (this.mEZESRGroup[n] == 0) {
                ++n6;
            }
            if (this.mMesoHelper == null || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(0, n)) || !this.mMesoHelper.isInMesoFragment(this.mMol.getBondAtom(1, n))) continue;
            bl = true;
        }
        if (n2 == 0) {
            this.mMol.setChirality(65536);
            return;
        }
        if (n3 != 0) {
            this.mMol.setChirality(0);
            return;
        }
        if (this.mIsMeso) {
            this.mMol.setChirality(131072 + (1 << n8));
            return;
        }
        if (n6 + n5 == n2 && !bl) {
            this.mMol.setChirality(196608);
        } else if (n4 == n2) {
            this.mMol.setChirality(262144);
        } else if (n7 == n2) {
            this.mMol.setChirality(327680);
        } else if (n4 == n2 - 1 && n6 == 1) {
            this.mMol.setChirality(393216);
        } else {
            this.mMol.setChirality(458752 + (1 << n8));
        }
    }

    private boolean canFindPseudoParities() {
        boolean bl;
        block31: {
            int n;
            boolean[] blArray;
            boolean[] blArray2;
            block32: {
                int n2;
                blArray2 = new boolean[this.mMol.getAtoms()];
                blArray = new boolean[this.mMol.getBonds()];
                n = 0;
                bl = false;
                if ((this.mMode & 0x80) != 0) {
                    this.mPseudoTHGroup = new int[this.mMol.getAtoms()];
                    this.mPseudoEZGroup = new int[this.mMol.getBonds()];
                }
                for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                    if (!this.mProTHAtomsInSameFragment[n2] || this.mTHParityIsPseudo[n2] || !this.canCalcTHParity(n2, 1)) continue;
                    this.mTHParityIsPseudo[n2] = true;
                    blArray2[n2] = true;
                    ++n;
                }
                for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
                    if (!this.mProEZAtomsInSameFragment[n2] || this.mEZParityIsPseudo[n2] || !this.canCalcEZParity(n2, 1)) continue;
                    this.mEZParityIsPseudo[n2] = true;
                    blArray[n2] = true;
                    ++n;
                }
                if (n != true) break block32;
                for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                    if (!blArray2[n2]) continue;
                    this.mTHParity[n2] = 0;
                    break;
                }
                for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
                    if (!blArray[n2]) continue;
                    this.mEZParity[n2] = 0;
                    break block31;
                }
                break block31;
            }
            if (n <= true) break block31;
            this.canEnsureFragments();
            this.mNoOfPseudoGroups = 0;
            for (CanonizerFragment canonizerFragment : this.mFragmentList) {
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = -1;
                int n10 = -1;
                for (n4 = 0; n4 < canonizerFragment.atom.length; ++n4) {
                    if (!blArray2[canonizerFragment.atom[n4]]) continue;
                    ++n5;
                    if (this.mTHParity[canonizerFragment.atom[n4]] != 1 && this.mTHParity[canonizerFragment.atom[n4]] != 2) continue;
                    ++n6;
                    bl = true;
                    if (n9 >= this.mCanRank[canonizerFragment.atom[n4]]) continue;
                    n9 = this.mCanRank[canonizerFragment.atom[n4]];
                    n7 = canonizerFragment.atom[n4];
                }
                for (n4 = 0; n4 < canonizerFragment.bond.length; ++n4) {
                    int n11;
                    int n12;
                    if (!blArray[canonizerFragment.bond[n4]]) continue;
                    ++n5;
                    n3 = this.mCanRank[this.mMol.getBondAtom(0, canonizerFragment.bond[n4])];
                    int n13 = n12 = n3 > (n11 = this.mCanRank[this.mMol.getBondAtom(1, canonizerFragment.bond[n4])]) ? (n3 << 16) + n11 : (n11 << 16) + n3;
                    if (this.mEZParity[canonizerFragment.bond[n4]] != 1 && this.mEZParity[canonizerFragment.bond[n4]] != 2) continue;
                    ++n6;
                    bl = true;
                    if (n10 >= n12) continue;
                    n10 = n12;
                    n8 = canonizerFragment.bond[n4];
                }
                if (n5 == 0) continue;
                if (n5 == 1) {
                    for (n4 = 0; n4 < canonizerFragment.atom.length; ++n4) {
                        if (!blArray2[canonizerFragment.atom[n4]]) continue;
                        this.mTHParity[canonizerFragment.atom[n4]] = 0;
                    }
                    for (n4 = 0; n4 < canonizerFragment.bond.length; ++n4) {
                        if (!blArray[canonizerFragment.bond[n4]]) continue;
                        this.mEZParity[canonizerFragment.bond[n4]] = 0;
                    }
                    continue;
                }
                if (n6 == 1) {
                    for (n4 = 0; n4 < canonizerFragment.atom.length; ++n4) {
                        if (!blArray2[canonizerFragment.atom[n4]]) continue;
                        this.mTHParity[canonizerFragment.atom[n4]] = 3;
                    }
                    for (n4 = 0; n4 < canonizerFragment.bond.length; ++n4) {
                        if (!blArray[canonizerFragment.bond[n4]]) continue;
                        this.mEZParity[canonizerFragment.bond[n4]] = 3;
                    }
                    continue;
                }
                if ((this.mMode & 0x80) != 0) {
                    ++this.mNoOfPseudoGroups;
                    for (n4 = 0; n4 < canonizerFragment.atom.length; ++n4) {
                        if (!blArray2[canonizerFragment.atom[n4]]) continue;
                        this.mPseudoTHGroup[canonizerFragment.atom[n4]] = this.mNoOfPseudoGroups;
                    }
                    for (n4 = 0; n4 < canonizerFragment.bond.length; ++n4) {
                        if (!blArray[canonizerFragment.bond[n4]]) continue;
                        this.mPseudoEZGroup[canonizerFragment.bond[n4]] = this.mNoOfPseudoGroups;
                    }
                }
                n4 = 0;
                if (n9 != -1) {
                    if (this.mTHParity[n7] == 2) {
                        n4 = 1;
                    }
                } else if (this.mEZParity[n8] == 2) {
                    n4 = 1;
                }
                if (n4 == 0) continue;
                block21: for (n3 = 0; n3 < canonizerFragment.atom.length; ++n3) {
                    if (!blArray2[canonizerFragment.atom[n3]]) continue;
                    switch (this.mTHParity[canonizerFragment.atom[n3]]) {
                        case 1: {
                            this.mTHParity[canonizerFragment.atom[n3]] = 2;
                            continue block21;
                        }
                        case 2: {
                            this.mTHParity[canonizerFragment.atom[n3]] = 1;
                        }
                    }
                }
                block22: for (n3 = 0; n3 < canonizerFragment.bond.length; ++n3) {
                    if (!blArray[canonizerFragment.bond[n3]]) continue;
                    switch (this.mEZParity[canonizerFragment.bond[n3]]) {
                        case 1: {
                            this.mEZParity[canonizerFragment.bond[n3]] = 2;
                            continue block22;
                        }
                        case 2: {
                            this.mEZParity[canonizerFragment.bond[n3]] = 1;
                        }
                    }
                }
            }
        }
        return bl;
    }

    private void canEnsureFragments() {
        if (this.mFragmentList != null) {
            return;
        }
        this.mFragmentList = new ArrayList();
        int n = 0;
        int[] nArray = new int[this.mMol.getAtoms()];
        int[] nArray2 = new int[this.mMol.getAtoms()];
        int[] nArray3 = new int[this.mMol.getBonds()];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (nArray[i] != 0 || !this.mMol.isRingAtom(i) && this.mMol.getAtomPi(i) != 1) continue;
            nArray2[0] = i;
            int n2 = 1;
            int n3 = 0;
            nArray[i] = ++n;
            boolean[] blArray = new boolean[this.mMol.getBonds()];
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < this.mMol.getConnAtoms(nArray2[j]); ++k) {
                    int n4 = this.mMol.getConnBond(nArray2[j], k);
                    if (!this.mMol.isRingBond(n4) && this.mMol.getBondOrder(n4) != 2 && !this.mMol.isBINAPChiralityBond(n4)) continue;
                    int n5 = this.mMol.getConnAtom(nArray2[j], k);
                    if (!blArray[n4]) {
                        nArray3[n3++] = n4;
                        blArray[n4] = true;
                    }
                    if (nArray[n5] != 0) continue;
                    nArray2[n2++] = n5;
                    nArray[n5] = n;
                }
            }
            this.mFragmentList.add(new CanonizerFragment(nArray2, n2, nArray3, n3));
        }
    }

    private int canPerformRanking() {
        int n;
        int n2 = this.canConsolidate();
        do {
            n = n2;
            this.canCalcNextBaseValues();
        } while (n != (n2 = this.canConsolidate()));
        return n2;
    }

    private void canCalcNextBaseValues() {
        int[] nArray = new int[this.mMaxConnAtoms];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            int n2 = this.mMol.getConnAtoms(i) + this.mMol.getMetalBondedConnAtoms(i);
            int n3 = 0;
            for (n = 0; n < this.mMol.getAllConnAtomsPlusMetalBonds(i); ++n) {
                int n4;
                if (n >= this.mMol.getConnAtoms(i) && n < this.mMol.getAllConnAtoms(i)) continue;
                int n5 = 2 * this.mCanRank[this.mMol.getConnAtom(i, n)];
                int n6 = this.mMol.getConnBond(i, n);
                if (this.mMol.getBondOrder(n6) == 2 && !this.mMol.isAromaticBond(n6)) {
                    ++n5;
                }
                for (n4 = 0; n4 < n3 && n5 >= nArray[n4]; ++n4) {
                }
                for (int j = n3; j > n4; --j) {
                    nArray[j] = nArray[j - 1];
                }
                nArray[n4] = n5;
                ++n3;
            }
            this.mCanBase[i].init(i);
            this.mCanBase[i].add(this.mAtomBits, this.mCanRank[i]);
            for (n = n2; n < this.mMaxConnAtoms; ++n) {
                this.mCanBase[i].add(this.mAtomBits + 1, 0L);
            }
            for (n = 0; n < n2; ++n) {
                this.mCanBase[i].add(this.mAtomBits + 1, nArray[n]);
            }
        }
    }

    private int canConsolidate() {
        int n = 0;
        Arrays.sort(this.mCanBase);
        for (int i = 0; i < this.mCanBase.length; ++i) {
            if (i == 0 || this.mCanBase[i].compareTo(this.mCanBase[i - 1]) != 0) {
                // empty if block
            }
            this.mCanRank[this.mCanBase[i].getAtom()] = ++n;
        }
        return n;
    }

    private boolean canCalcTHParity(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mTHParity[n] != 0) {
            return false;
        }
        if (this.mMol.getAtomicNo(n) != 5 && this.mMol.getAtomicNo(n) != 6 && this.mMol.getAtomicNo(n) != 7 && this.mMol.getAtomicNo(n) != 14 && this.mMol.getAtomicNo(n) != 15 && this.mMol.getAtomicNo(n) != 16) {
            return false;
        }
        if (this.mMol.getAtomPi(n) != 0) {
            if (this.mMol.isCentralAlleneAtom(n)) {
                return this.canCalcAlleneParity(n, n2);
            }
            if (this.mMol.getAtomicNo(n) != 15 && this.mMol.getAtomicNo(n) != 16) {
                return false;
            }
        }
        if (this.mMol.getConnAtoms(n) < 3 || this.mMol.getAllConnAtoms(n) > 4) {
            return false;
        }
        if (this.mMol.getAtomCharge(n) > 0 && this.mMol.getAtomicNo(n) == 6) {
            return false;
        }
        if (this.mMol.getAtomicNo(n) == 5 && this.mMol.getAllConnAtoms(n) != 4) {
            return false;
        }
        if (this.mMol.getAtomicNo(n) == 7 && !this.mNitrogenQualifiesForParity[n]) {
            return false;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        boolean[] blArray = new boolean[4];
        for (n6 = 0; n6 < this.mMol.getAllConnAtoms(n); ++n6) {
            n5 = -1;
            n4 = 0;
            for (n3 = 0; n3 < this.mMol.getAllConnAtoms(n); ++n3) {
                if (blArray[n3] || n5 >= this.mCanRank[this.mMol.getConnAtom(n, n3)]) continue;
                n5 = this.mCanRank[this.mMol.getConnAtom(n, n3)];
                n4 = n3;
            }
            nArray[n6] = n4;
            nArray2[n6] = n5;
            blArray[n4] = true;
        }
        if (this.mMol.getAllConnAtoms(n) == 4 && nArray2[0] == nArray2[1] && nArray2[2] == nArray2[3]) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(n) == 4 && (nArray2[0] == nArray2[2] || nArray2[1] == nArray2[3])) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(n) == 3 && nArray2[0] == nArray2[2]) {
            return false;
        }
        n6 = 0;
        n5 = 0;
        n4 = 0;
        for (n3 = 1; n3 < this.mMol.getAllConnAtoms(n); ++n3) {
            if (nArray2[n3 - 1] != nArray2[n3]) continue;
            if (n2 == 1 || nArray2[n3] == 0) {
                return false;
            }
            n6 = this.mMol.getConnAtom(n, nArray[n3 - 1]);
            n5 = this.mMol.getConnAtom(n, nArray[n3]);
            if (n2 == 3 && this.mMol.isRingBond(this.mMol.getConnBond(n, nArray[n3]))) {
                this.mProTHAtomsInSameFragment[n] = true;
            }
            n4 = 1;
        }
        if (n2 != 1 && n4 == 0) {
            return false;
        }
        n3 = this.mZCoordinatesAvailable ? this.canCalcTHParity3D(n, nArray) : this.canCalcTHParity2D(n, nArray);
        if (n2 == 1) {
            this.mTHParity[n] = n3;
        } else if (n2 == 2) {
            if (n3 == 1) {
                this.mCanBase[n6].add(this.mCanRank[n]);
            } else if (n3 == 2) {
                this.mCanBase[n5].add(this.mCanRank[n]);
            }
        }
        return true;
    }

    private byte canCalcTHParity2D(int n, int[] nArray) {
        int n2;
        int n3;
        int[][] nArrayArray = new int[][]{{2, 1, 2, 1}, {1, 2, 2, 1}, {1, 1, 2, 2}, {2, 1, 1, 2}, {2, 2, 1, 1}, {1, 2, 1, 2}};
        double[] dArray = new double[this.mMol.getAllConnAtoms(n)];
        for (n3 = 0; n3 < this.mMol.getAllConnAtoms(n); ++n3) {
            dArray[n3] = this.mMol.getBondAngle(this.mMol.getConnAtom(n, nArray[n3]), n);
        }
        n3 = (byte)this.mMol.getFisherProjectionParity(n, nArray, dArray, null);
        if (n3 != 3) {
            return (byte)n3;
        }
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.mMol.getAllConnAtoms(n); ++n2) {
            int n6 = this.mMol.getConnBond(n, nArray[n2]);
            if (this.mMol.getBondAtom(0, n6) != n) continue;
            if (this.mMol.getBondType(n6) == 129) {
                if (n5 != 0) {
                    this.mMol.setStereoProblem(n);
                }
                n4 = n2;
                n5 = 1;
            }
            if (this.mMol.getBondType(n6) != 257) continue;
            if (n5 != 0) {
                this.mMol.setStereoProblem(n);
            }
            n4 = n2;
            n5 = 2;
        }
        if (n5 == 0) {
            return 3;
        }
        for (n2 = 1; n2 < this.mMol.getAllConnAtoms(n); ++n2) {
            if (!(dArray[n2] < dArray[0])) continue;
            int n7 = n2;
            dArray[n7] = dArray[n7] + Math.PI * 2;
        }
        if (this.mMol.getAllConnAtoms(n) == 3) {
            switch (n4) {
                case 0: {
                    if (!(dArray[1] < dArray[2] && dArray[2] - dArray[1] < Math.PI) && (!(dArray[1] > dArray[2]) || !(dArray[1] - dArray[2] > Math.PI))) break;
                    n5 = 3 - n5;
                    break;
                }
                case 1: {
                    if (!(dArray[2] - dArray[0] > Math.PI)) break;
                    n5 = 3 - n5;
                    break;
                }
                case 2: {
                    if (!(dArray[1] - dArray[0] < Math.PI)) break;
                    n5 = 3 - n5;
                }
            }
            return n5 == 1 ? (byte)2 : 1;
        }
        n2 = 0;
        if (dArray[1] <= dArray[2] && dArray[2] <= dArray[3]) {
            n2 = 0;
        } else if (dArray[1] <= dArray[3] && dArray[3] <= dArray[2]) {
            n2 = 1;
        } else if (dArray[2] <= dArray[1] && dArray[1] <= dArray[3]) {
            n2 = 2;
        } else if (dArray[2] <= dArray[3] && dArray[3] <= dArray[1]) {
            n2 = 3;
        } else if (dArray[3] <= dArray[1] && dArray[1] <= dArray[2]) {
            n2 = 4;
        } else if (dArray[3] <= dArray[2] && dArray[2] <= dArray[1]) {
            n2 = 5;
        }
        return nArrayArray[n2][n4] == n5 ? (byte)2 : 1;
    }

    private byte canCalcTHParity3D(int n, int[] nArray) {
        double d;
        int[] nArray2 = new int[4];
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            nArray2[i] = this.mMol.getConnAtom(n, nArray[i]);
        }
        if (this.mMol.getAllConnAtoms(n) == 3) {
            nArray2[3] = n;
        }
        double[][] dArray = new double[3][3];
        int n2 = this.mMol.getAtomParity(n);
        if (n2 == 0) {
            double[] dArray2 = new double[]{dArray[0][1] * dArray[1][2] - dArray[0][2] * dArray[1][1], dArray[0][2] * dArray[1][0] - dArray[0][0] * dArray[1][2], dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0]};
            d = (dArray[2][0] * dArray2[0] + dArray[2][1] * dArray2[1] + dArray[2][2] * dArray2[2]) / (Math.sqrt(dArray[2][0] * dArray[2][0] + dArray[2][1] * dArray[2][1] + dArray[2][2] * dArray[2][2]) * Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
        } else {
            d = n2 == 1 ? 1 : -1;
        }
        return d > 0.0 ? (byte)1 : 2;
    }

    private boolean canCalcAlleneParity(int n, int n2) {
        byte by;
        if (this.mMol.getAtomicNo(n) != 6 && this.mMol.getAtomicNo(n) != 7) {
            return false;
        }
        int n3 = this.mMol.getConnAtom(n, 0);
        int n4 = this.mMol.getConnAtom(n, 1);
        if (this.mMol.getAtomPi(n3) != 1 || this.mMol.getAtomPi(n4) != 1) {
            return false;
        }
        if (this.mMol.getConnAtoms(n3) == 1 || this.mMol.getConnAtoms(n4) == 1) {
            return false;
        }
        if (this.mMol.getAllConnAtoms(n3) > 3 || this.mMol.getAllConnAtoms(n4) > 3) {
            return false;
        }
        EZHalfParity eZHalfParity = new EZHalfParity(this.mMol, this.mCanRank, n, n3);
        if (eZHalfParity.mRanksEqual && n2 == 1) {
            return false;
        }
        EZHalfParity eZHalfParity2 = new EZHalfParity(this.mMol, this.mCanRank, n, n4);
        if (eZHalfParity2.mRanksEqual && n2 == 1) {
            return false;
        }
        if (eZHalfParity.mRanksEqual && eZHalfParity2.mRanksEqual) {
            return false;
        }
        if (n2 == 3) {
            if (eZHalfParity.mRanksEqual && eZHalfParity.mInSameFragment) {
                this.mProTHAtomsInSameFragment[n] = true;
            }
            if (eZHalfParity2.mRanksEqual && eZHalfParity2.mInSameFragment) {
                this.mProTHAtomsInSameFragment[n] = true;
            }
        }
        byte by2 = by = this.mZCoordinatesAvailable ? this.canCalcAlleneParity3D(eZHalfParity, eZHalfParity2) : this.canCalcAlleneParity2D(eZHalfParity, eZHalfParity2);
        if (n2 == 1) {
            this.mTHParity[n] = by;
        } else if (n2 == 2) {
            if (eZHalfParity.mRanksEqual) {
                if (by == 1) {
                    this.mCanBase[eZHalfParity.mHighConn].add(this.mCanRank[n3]);
                } else {
                    this.mCanBase[eZHalfParity.mLowConn].add(this.mCanRank[n3]);
                }
            }
            if (eZHalfParity2.mRanksEqual) {
                if (by == 2) {
                    this.mCanBase[eZHalfParity2.mHighConn].add(this.mCanRank[n4]);
                } else {
                    this.mCanBase[eZHalfParity2.mLowConn].add(this.mCanRank[n4]);
                }
            }
        }
        return true;
    }

    private byte canCalcAlleneParity2D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        int n = eZHalfParity.getValue();
        int n2 = eZHalfParity2.getValue();
        if (n == -1 || n2 == -1 || (n + n2 & 1) == 0) {
            return 3;
        }
        byte by = 0;
        switch (n + n2) {
            case 3: 
            case 7: {
                by = 2;
                break;
            }
            case 5: {
                by = 1;
            }
        }
        return by;
    }

    private byte canCalcAlleneParity3D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        int[] nArray = new int[]{eZHalfParity.mHighConn, eZHalfParity.mCentralAxialAtom, eZHalfParity2.mCentralAxialAtom, eZHalfParity2.mHighConn};
        double d = this.mMol.calculateTorsion(nArray);
        if (Math.abs(d) < 0.3 || Math.abs(d) > 2.8415926535897933) {
            return 3;
        }
        if (d < 0.0) {
            return 2;
        }
        return 1;
    }

    private boolean canCalcBINAPParity(int n, int n2) {
        byte by;
        if (!this.mMol.isBINAPChiralityBond(n)) {
            return false;
        }
        int n3 = this.mMol.getBondAtom(0, n);
        int n4 = this.mMol.getBondAtom(1, n);
        EZHalfParity eZHalfParity = new EZHalfParity(this.mMol, this.mCanRank, n3, n4);
        if (eZHalfParity.mRanksEqual && n2 == 1) {
            return false;
        }
        EZHalfParity eZHalfParity2 = new EZHalfParity(this.mMol, this.mCanRank, n4, n3);
        if (eZHalfParity2.mRanksEqual && n2 == 1) {
            return false;
        }
        if (eZHalfParity.mRanksEqual && eZHalfParity2.mRanksEqual) {
            return false;
        }
        if (n2 == 3) {
            if (eZHalfParity.mRanksEqual) {
                this.mProEZAtomsInSameFragment[n] = this.hasSecondBINAPBond(n4);
            }
            if (eZHalfParity2.mRanksEqual) {
                this.mProEZAtomsInSameFragment[n] = this.hasSecondBINAPBond(n3);
            }
        }
        byte by2 = by = this.mZCoordinatesAvailable ? this.canCalcBINAPParity3D(eZHalfParity, eZHalfParity2) : this.canCalcBINAPParity2D(eZHalfParity, eZHalfParity2);
        if (n2 == 1) {
            this.mEZParity[n] = by;
        } else if (n2 == 2) {
            if (eZHalfParity.mRanksEqual) {
                if (by == 2) {
                    this.mCanBase[eZHalfParity.mHighConn].add(this.mCanRank[n4]);
                } else {
                    this.mCanBase[eZHalfParity.mLowConn].add(this.mCanRank[n4]);
                }
            }
            if (eZHalfParity2.mRanksEqual) {
                if (by == 2) {
                    this.mCanBase[eZHalfParity2.mHighConn].add(this.mCanRank[n3]);
                } else {
                    this.mCanBase[eZHalfParity2.mLowConn].add(this.mCanRank[n3]);
                }
            }
        }
        return true;
    }

    private byte canCalcBINAPParity2D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        int n = eZHalfParity.getValue();
        int n2 = eZHalfParity2.getValue();
        if (n == -1 || n2 == -1 || (n + n2 & 1) == 0) {
            return 3;
        }
        byte by = 0;
        switch (n + n2) {
            case 3: 
            case 7: {
                by = 1;
                break;
            }
            case 5: {
                by = 2;
            }
        }
        return by;
    }

    private byte canCalcBINAPParity3D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        int[] nArray = new int[]{eZHalfParity.mHighConn, eZHalfParity.mCentralAxialAtom, eZHalfParity2.mCentralAxialAtom, eZHalfParity2.mHighConn};
        double d = this.mMol.calculateTorsion(nArray);
        if (Math.abs(d) < 0.3 || Math.abs(d) > 2.8415926535897933) {
            return 3;
        }
        if (d < 0.0) {
            return 1;
        }
        return 2;
    }

    private boolean hasSecondBINAPBond(int n) {
        RingCollection ringCollection = this.mMol.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (!ringCollection.isAromatic(i) || !ringCollection.isAtomMember(i, n)) continue;
            for (int n2 : ringCollection.getRingAtoms(i)) {
                if (n2 == n) continue;
                for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                    if (!this.mMol.isBINAPChiralityBond(this.mMol.getConnBond(n2, j))) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean canCalcEZParity(int n, int n2) {
        int n3;
        if (this.mEZParity[n] != 0) {
            return false;
        }
        if (this.mMol.getBondOrder(n) == 1) {
            return this.canCalcBINAPParity(n, n2);
        }
        if (this.mMol.getBondOrder(n) != 2) {
            return false;
        }
        if (this.mMol.isAromaticBond(n)) {
            return false;
        }
        int n4 = this.mMol.getBondAtom(0, n);
        int n5 = this.mMol.getBondAtom(1, n);
        if (this.mMol.getConnAtoms(n4) == 1 || this.mMol.getConnAtoms(n5) == 1) {
            return false;
        }
        if (this.mMol.getConnAtoms(n4) > 3 || this.mMol.getConnAtoms(n5) > 3) {
            return false;
        }
        if (this.mMol.getAtomPi(n4) == 2 || this.mMol.getAtomPi(n5) == 2) {
            return false;
        }
        EZHalfParity eZHalfParity = new EZHalfParity(this.mMol, this.mCanRank, n5, n4);
        if (eZHalfParity.mRanksEqual && n2 == 1) {
            return false;
        }
        EZHalfParity eZHalfParity2 = new EZHalfParity(this.mMol, this.mCanRank, n4, n5);
        if (eZHalfParity2.mRanksEqual && n2 == 1) {
            return false;
        }
        if (eZHalfParity.mRanksEqual && eZHalfParity2.mRanksEqual) {
            return false;
        }
        if (n2 == 3) {
            if (eZHalfParity.mRanksEqual && eZHalfParity.mInSameFragment) {
                this.mProEZAtomsInSameFragment[n] = true;
            }
            if (eZHalfParity2.mRanksEqual && eZHalfParity2.mInSameFragment) {
                this.mProEZAtomsInSameFragment[n] = true;
            }
        }
        int n6 = this.mMol.isBondParityUnknownOrNone(n) ? 3 : (n3 = this.mZCoordinatesAvailable ? (int)this.canCalcEZParity3D(eZHalfParity, eZHalfParity2) : (int)this.canCalcEZParity2D(eZHalfParity, eZHalfParity2));
        if (n2 == 1) {
            this.mEZParity[n] = n3;
        } else if (n2 == 2) {
            if (eZHalfParity.mRanksEqual) {
                if (n3 == 1) {
                    this.mCanBase[eZHalfParity.mHighConn].add(this.mCanRank[n4]);
                } else if (n3 == 2) {
                    this.mCanBase[eZHalfParity.mLowConn].add(this.mCanRank[n4]);
                }
            }
            if (eZHalfParity2.mRanksEqual) {
                if (n3 == 1) {
                    this.mCanBase[eZHalfParity2.mHighConn].add(this.mCanRank[n5]);
                } else if (n3 == 2) {
                    this.mCanBase[eZHalfParity2.mLowConn].add(this.mCanRank[n5]);
                }
            }
        }
        return true;
    }

    private byte canCalcEZParity2D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        if (eZHalfParity.getValue() == -1 || eZHalfParity2.getValue() == -1) {
            return 3;
        }
        if (((eZHalfParity.getValue() | eZHalfParity2.getValue()) & 1) != 0) {
            return 3;
        }
        return eZHalfParity.getValue() == eZHalfParity2.getValue() ? (byte)1 : 2;
    }

    private byte canCalcEZParity3D(EZHalfParity eZHalfParity, EZHalfParity eZHalfParity2) {
        double[] dArray = new double[]{this.mMol.getAtomX(eZHalfParity2.mCentralAxialAtom) - this.mMol.getAtomX(eZHalfParity.mCentralAxialAtom), this.mMol.getAtomY(eZHalfParity2.mCentralAxialAtom) - this.mMol.getAtomY(eZHalfParity.mCentralAxialAtom), this.mMol.getAtomZ(eZHalfParity2.mCentralAxialAtom) - this.mMol.getAtomZ(eZHalfParity.mCentralAxialAtom)};
        double[] dArray2 = new double[]{this.mMol.getAtomX(eZHalfParity.mHighConn) - this.mMol.getAtomX(eZHalfParity.mCentralAxialAtom), this.mMol.getAtomY(eZHalfParity.mHighConn) - this.mMol.getAtomY(eZHalfParity.mCentralAxialAtom), this.mMol.getAtomZ(eZHalfParity.mHighConn) - this.mMol.getAtomZ(eZHalfParity.mCentralAxialAtom)};
        double[] dArray3 = new double[]{this.mMol.getAtomX(eZHalfParity2.mHighConn) - this.mMol.getAtomX(eZHalfParity2.mCentralAxialAtom), this.mMol.getAtomY(eZHalfParity2.mHighConn) - this.mMol.getAtomY(eZHalfParity2.mCentralAxialAtom), this.mMol.getAtomZ(eZHalfParity2.mHighConn) - this.mMol.getAtomZ(eZHalfParity2.mCentralAxialAtom)};
        double[] dArray4 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        double[] dArray5 = new double[]{dArray[1] * dArray4[2] - dArray[2] * dArray4[1], dArray[2] * dArray4[0] - dArray[0] * dArray4[2], dArray[0] * dArray4[1] - dArray[1] * dArray4[0]};
        double d = (dArray2[0] * dArray5[0] + dArray2[1] * dArray5[1] + dArray2[2] * dArray5[2]) / (Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]) * Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]));
        double d2 = (dArray3[0] * dArray5[0] + dArray3[1] * dArray5[1] + dArray3[2] * dArray5[2]) / (Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]) * Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]));
        return d < 0.0 ^ d2 < 0.0 ? (byte)1 : 2;
    }

    private void flagStereoProblems() {
        int n;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mTHParity[n] == 3 && !this.mMol.isAtomConfigurationUnknown(n)) {
                this.mMol.setStereoProblem(n);
            }
            if ((this.mMol.getAtomESRType(n) == 1 || this.mMol.getAtomESRType(n) == 2) && this.mTHParity[n] == 3) {
                this.mMol.setStereoProblem(n);
            }
            if (!this.mMol.isAtomConfigurationUnknown(n) || this.mTHParity[n] == 3 || this.isUnknownBINAPBondAtom(n)) continue;
            this.mMol.setStereoProblem(n);
        }
        for (n = 0; n < this.mMol.getAllBonds(); ++n) {
            if (!this.mMol.isStereoBond(n) || this.isJustifiedStereoBond(n)) continue;
            this.mMol.setStereoProblem(this.mMol.getBondAtom(0, n));
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondOrder(n) == 2) {
                if (this.mMol.isBondParityUnknownOrNone(n) && (this.mEZParity[n] == 1 || this.mEZParity[n] == 2)) {
                    this.mEZParity[n] = 3;
                    this.mMol.setBondType(n, 386);
                }
                if (this.mEZParity[n] == 3 && !this.mEZParityIsPseudo[n] && this.mMol.getBondType(n) != 386) {
                    this.mMol.setStereoProblem(this.mMol.getBondAtom(0, n));
                    this.mMol.setStereoProblem(this.mMol.getBondAtom(1, n));
                }
            }
            if (this.mMol.getBondType(n) == 1 && this.mEZParity[n] == 3 && !this.mMol.isAtomConfigurationUnknown(this.mMol.getBondAtom(0, n)) && !this.mMol.isAtomConfigurationUnknown(this.mMol.getBondAtom(1, n))) {
                this.mMol.setStereoProblem(this.mMol.getBondAtom(0, n));
                this.mMol.setStereoProblem(this.mMol.getBondAtom(1, n));
            }
            if (this.mMol.getBondESRType(n) != 1 && this.mMol.getBondESRType(n) != 2 || this.mMol.getBondType(n) == 1 && (this.mEZParity[n] == 1 || this.mEZParity[n] == 2)) continue;
            this.mMol.setStereoProblem(this.mMol.getBondAtom(0, n));
            this.mMol.setStereoProblem(this.mMol.getBondAtom(1, n));
        }
    }

    private boolean isUnknownBINAPBondAtom(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mEZParity[this.mMol.getConnBond(n, i)] != 3 || this.mMol.getConnBondOrder(n, i) != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isJustifiedStereoBond(int n) {
        int n2 = this.mMol.getBondAtom(0, n);
        if (n2 >= this.mMol.getAtoms()) {
            return false;
        }
        if (this.mTHParity[n2] == 1 || this.mTHParity[n2] == 2) {
            return true;
        }
        if (this.mTHParity[n2] == 3) {
            return false;
        }
        int n3 = this.mMol.findBINAPChiralityBond(n2);
        if (n3 != -1) {
            return this.mEZParity[n3] == 1 || this.mEZParity[n3] == 2;
        }
        for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
            if (this.mMol.getConnBondOrder(n2, i) != 2 || this.mTHParity[this.mMol.getConnAtom(n2, i)] != 1 && this.mTHParity[this.mMol.getConnAtom(n2, i)] != 2) continue;
            return true;
        }
        return false;
    }

    private void generateGraph() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mMol.getAtoms() == 0) {
            return;
        }
        if (this.mGraphGenerated) {
            return;
        }
        this.mGraphRings = 0;
        int n7 = 0;
        for (int i = 1; i < this.mMol.getAtoms(); ++i) {
            if (this.mCanRank[i] <= this.mCanRank[n7]) continue;
            n7 = i;
        }
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        boolean[] blArray2 = new boolean[this.mMol.getBonds()];
        this.mGraphIndex = new int[this.mMol.getAtoms()];
        this.mGraphAtom = new int[this.mMol.getAtoms()];
        this.mGraphFrom = new int[this.mMol.getAtoms()];
        this.mGraphBond = new int[this.mMol.getBonds()];
        this.mGraphAtom[0] = n7;
        this.mGraphIndex[n7] = 0;
        blArray[n7] = true;
        int n8 = 1;
        int n9 = 0;
        int n10 = 1;
        int n11 = 0;
        while (n9 < this.mMol.getAtoms()) {
            if (n9 < n10) {
                while (true) {
                    n6 = 0;
                    n5 = 0;
                    n4 = -1;
                    n3 = this.mGraphAtom[n9];
                    for (n2 = 0; n2 < this.mMol.getAllConnAtomsPlusMetalBonds(n3); ++n2) {
                        if (n2 >= this.mMol.getConnAtoms(n3) && n2 < this.mMol.getAllConnAtoms(n3) || blArray[n = this.mMol.getConnAtom(n3, n2)] || this.mCanRank[n] <= n4) continue;
                        n6 = n;
                        n5 = this.mMol.getConnBond(n3, n2);
                        n4 = this.mCanRank[n];
                    }
                    if (n4 == -1) break;
                    this.mGraphIndex[n6] = n10;
                    this.mGraphFrom[n10] = n9;
                    this.mGraphAtom[n10++] = n6;
                    this.mGraphBond[n11++] = n5;
                    blArray[n6] = true;
                    blArray2[n5] = true;
                }
                ++n9;
                continue;
            }
            n6 = 0;
            n5 = -1;
            for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
                if (blArray[n4] || this.mCanRank[n4] <= n5) continue;
                n6 = n4;
                n5 = this.mCanRank[n4];
            }
            ++n8;
            this.mGraphIndex[n6] = n10;
            this.mGraphFrom[n10] = -1;
            this.mGraphAtom[n10++] = n6;
            blArray[n6] = true;
        }
        this.mGraphClosure = new int[2 * (this.mMol.getBonds() - n11)];
        while (true) {
            n6 = this.mMol.getMaxAtoms();
            n5 = this.mMol.getMaxAtoms();
            n4 = -1;
            for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
                if (blArray2[n3]) continue;
                if (this.mGraphIndex[this.mMol.getBondAtom(0, n3)] < this.mGraphIndex[this.mMol.getBondAtom(1, n3)]) {
                    n2 = this.mGraphIndex[this.mMol.getBondAtom(0, n3)];
                    n = this.mGraphIndex[this.mMol.getBondAtom(1, n3)];
                } else {
                    n2 = this.mGraphIndex[this.mMol.getBondAtom(1, n3)];
                    n = this.mGraphIndex[this.mMol.getBondAtom(0, n3)];
                }
                if (n2 >= n6 && (n2 != n6 || n >= n5)) continue;
                n6 = n2;
                n5 = n;
                n4 = n3;
            }
            if (n4 == -1) break;
            blArray2[n4] = true;
            this.mGraphBond[n11++] = n4;
            this.mGraphClosure[2 * this.mGraphRings] = n6;
            this.mGraphClosure[2 * this.mGraphRings + 1] = n5;
            ++this.mGraphRings;
        }
        this.mGraphGenerated = true;
    }

    public StereoMolecule getCanMolecule() {
        return this.getCanMolecule(false);
    }

    public StereoMolecule getCanMolecule(boolean bl) {
        int n;
        int n2;
        this.generateGraph();
        StereoMolecule stereoMolecule = new StereoMolecule(this.mMol.getAtoms(), this.mMol.getBonds());
        stereoMolecule.setFragment(this.mMol.isFragment());
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            this.mMol.copyAtom(stereoMolecule, this.mGraphAtom[n2], 0, 0);
            stereoMolecule.setAtomESR(n2, this.mTHESRType[this.mGraphAtom[n2]], this.mTHESRGroup[this.mGraphAtom[n2]]);
        }
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            this.mMol.copyBond(stereoMolecule, this.mGraphBond[n2], 0, 0, this.mGraphIndex, false);
            if (!stereoMolecule.isStereoBond(n2) && stereoMolecule.getBondAtom(0, n2) > stereoMolecule.getBondAtom(1, n2)) {
                n = stereoMolecule.getBondAtom(0, n2);
                stereoMolecule.setBondAtom(0, n2, stereoMolecule.getBondAtom(1, n2));
                stereoMolecule.setBondAtom(1, n2, n);
            }
            stereoMolecule.setBondESR(n2, this.mEZESRType[this.mGraphBond[n2]], this.mEZESRGroup[this.mGraphBond[n2]]);
        }
        if (bl) {
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                n = this.mGraphAtom[n2];
                for (int i = this.mMol.getConnAtoms(n); i < this.mMol.getAllConnAtoms(n); ++i) {
                    int n3 = this.mMol.copyAtom(stereoMolecule, this.mMol.getConnAtom(n, i), 0, 0);
                    this.mMol.copyBond(stereoMolecule, this.mMol.getConnBond(n, i), 0, 0, this.mGraphIndex[n], n3, false);
                }
            }
        }
        for (n2 = 0; n2 < stereoMolecule.getAllBonds(); ++n2) {
            n = stereoMolecule.getBondAtom(0, n2);
            if (!this.mTHParityIsMesoInverted[this.mGraphAtom[n]]) continue;
            if (stereoMolecule.getBondType(n2) == 257) {
                stereoMolecule.setBondType(n2, 129);
                continue;
            }
            if (stereoMolecule.getBondType(n2) != 129) continue;
            stereoMolecule.setBondType(n2, 257);
        }
        this.mMol.copyMoleculeProperties(stereoMolecule);
        this.mMol.invalidateHelperArrays(8);
        return stereoMolecule;
    }

    public void setUnknownParitiesToExplicitlyUnknown() {
        int n;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mMol.isAtomConfigurationUnknown(n) || this.mTHParity[n] != 3) continue;
            this.mMol.setAtomConfigurationUnknown(n, true);
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mEZParity[n] != 3) continue;
            int n2 = this.mMol.getBondOrder(n);
            if (n2 == 1) {
                this.mMol.setAtomConfigurationUnknown(this.mMol.getBondAtom(0, n), true);
                continue;
            }
            if (n2 != 2) continue;
            this.mMol.setBondType(n, 386);
        }
    }

    public boolean setSingleUnknownAsRacemicParity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mTHParity[n] == 0 || this.mTHParityIsPseudo[n]) continue;
            if (this.mTHParity[n] == 3) {
                ++n2;
                continue;
            }
            ++n3;
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(n) != 1 || this.mEZParity[n] == 0 || this.mEZParityIsPseudo[n]) continue;
            if (this.mEZParity[n] == 3) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n3 == 0 && n2 == 1) {
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                int n4;
                int n5;
                if (this.mTHParity[n] != 3 || this.mTHParityIsPseudo[n]) continue;
                if (this.mMol.getAtomPi(n) == 2 && this.mMol.getConnAtoms(n) == 2) {
                    for (n5 = 0; n5 < 2; ++n5) {
                        n4 = this.mMol.getConnAtom(n, n5);
                        for (int i = 0; i < this.mMol.getConnAtoms(n4); ++i) {
                            if (!this.mMol.isStereoBond(this.mMol.getConnBond(n4, i))) continue;
                            return false;
                        }
                    }
                } else {
                    for (n5 = 0; n5 < this.mMol.getConnAtoms(n); ++n5) {
                        if (!this.mMol.isStereoBond(this.mMol.getConnBond(n, n5))) continue;
                        return false;
                    }
                }
                this.mTHParity[n] = 2;
                this.mTHESRType[n] = 1;
                this.mTHESRGroup[n] = 0;
                this.mMol.setAtomParity(n, 2, false);
                this.mMol.setAtomESR(n, 1, 0);
                n5 = this.mMol.getAtomPreferredStereoBond(n);
                this.mMol.setBondType(n5, 257);
                if (this.mMol.getBondAtom(1, n5) == n) {
                    n4 = this.mMol.getBondAtom(0, n5);
                    this.mMol.setBondAtom(0, n5, n);
                    this.mMol.setBondAtom(1, n5, n4);
                }
                return true;
            }
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                int n6;
                int n7;
                if (this.mMol.getBondType(n) != 1 || this.mEZParity[n] == 0 || this.mEZParityIsPseudo[n]) continue;
                for (n7 = 0; n7 < 2; ++n7) {
                    n6 = this.mMol.getBondAtom(n7, n);
                    for (int i = 0; i < this.mMol.getConnAtoms(n6); ++i) {
                        if (!this.mMol.isStereoBond(this.mMol.getConnBond(n6, i))) continue;
                        return false;
                    }
                }
                this.mEZParity[n] = 2;
                this.mEZESRType[n] = 1;
                this.mEZESRGroup[n] = 0;
                this.mMol.setBondParity(n, 2, false);
                this.mMol.setAtomESR(n, 1, 0);
                n7 = this.mMol.getBondPreferredStereoBond(n);
                this.mMol.setBondType(n7, 257);
                if (this.mMol.getBondAtom(1, n7) == this.mMol.getBondAtom(0, n) || this.mMol.getBondAtom(1, n7) == this.mMol.getBondAtom(1, n)) {
                    n6 = this.mMol.getBondAtom(0, n7);
                    this.mMol.setBondAtom(0, n7, this.mMol.getBondAtom(1, n7));
                    this.mMol.setBondAtom(1, n7, n6);
                }
                return true;
            }
        }
        return false;
    }

    public String getIDCode() {
        if (this.mIDCode == null) {
            this.generateGraph();
            if ((this.mMode & 0x800) == 0) {
                this.idGenerateConfigurations();
                this.idNormalizeESRGroupNumbers();
            }
            this.idCodeCreate();
        }
        return this.mIDCode;
    }

    public int[] getFinalRank() {
        return this.mCanRank;
    }

    public int getSymmetryRank(int n) {
        return this.mCanRankBeforeTieBreaking == null ? -1 : this.mCanRankBeforeTieBreaking[n];
    }

    public int[] getSymmetryRanks() {
        return this.mCanRankBeforeTieBreaking;
    }

    private void idCodeCreate() {
        int n;
        boolean[] blArray;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.encodeBitsStart(false);
        this.encodeBits(9L, 4);
        int n9 = Math.max(Canonizer.getNeededBits(this.mMol.getAtoms()), Canonizer.getNeededBits(this.mMol.getBonds()));
        this.encodeBits(n9, 4);
        if (n9 == 0) {
            this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
            this.encodeBits(0L, 1);
            this.mIDCode = this.encodeBitsEnd();
            return;
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
            if ((this.mMol.getAtomQueryFeatures(n8) & 1L) != 0L) continue;
            switch (this.mMol.getAtomicNo(n8)) {
                case 6: {
                    break;
                }
                case 7: {
                    ++n13;
                    break;
                }
                case 8: {
                    ++n12;
                    break;
                }
                default: {
                    ++n11;
                }
            }
            if (this.mMol.getAtomCharge(n8) == 0) continue;
            ++n10;
        }
        this.encodeBits(this.mMol.getAtoms(), n9);
        this.encodeBits(this.mMol.getBonds(), n9);
        this.encodeBits(n13, n9);
        this.encodeBits(n12, n9);
        this.encodeBits(n11, n9);
        this.encodeBits(n10, n9);
        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n8]) != 7 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n8]) & 1L) != 0L) continue;
            this.encodeBits(n8, n9);
        }
        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n8]) != 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n8]) & 1L) != 0L) continue;
            this.encodeBits(n8, n9);
        }
        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n8]) == 6 || this.mMol.getAtomicNo(this.mGraphAtom[n8]) == 7 || this.mMol.getAtomicNo(this.mGraphAtom[n8]) == 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n8]) & 1L) != 0L) continue;
            this.encodeBits(n8, n9);
            this.encodeBits(this.mMol.getAtomicNo(this.mGraphAtom[n8]), 8);
        }
        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
            if (this.mMol.getAtomCharge(this.mGraphAtom[n8]) == 0 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n8]) & 1L) != 0L) continue;
            this.encodeBits(n8, n9);
            this.encodeBits(8 + this.mMol.getAtomCharge(this.mGraphAtom[n8]), 4);
        }
        n8 = 0;
        int n14 = 0;
        for (n7 = 1; n7 < this.mMol.getAtoms(); ++n7) {
            if (this.mGraphFrom[n7] == -1) {
                n6 = 0;
            } else {
                n6 = 1 + this.mGraphFrom[n7] - n14;
                n14 = this.mGraphFrom[n7];
            }
            if (n8 >= n6) continue;
            n8 = n6;
        }
        n7 = Canonizer.getNeededBits(n8);
        this.encodeBits(n7, 4);
        n14 = 0;
        for (n6 = 1; n6 < this.mMol.getAtoms(); ++n6) {
            if (this.mGraphFrom[n6] == -1) {
                n5 = 0;
            } else {
                n5 = 1 + this.mGraphFrom[n6] - n14;
                n14 = this.mGraphFrom[n6];
            }
            this.encodeBits(n5, n7);
        }
        for (n6 = 0; n6 < 2 * this.mGraphRings; ++n6) {
            this.encodeBits(this.mGraphClosure[n6], n9);
        }
        for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
            n5 = (this.mMol.getBondQueryFeatures(this.mGraphBond[n6]) & 0x1FE00) != 0 || this.mMol.getBondType(this.mGraphBond[n6]) == 32 ? 1 : (this.mMol.isDelocalizedBond(this.mGraphBond[n6]) ? 0 : Math.min(3, this.mMol.getBondOrder(this.mGraphBond[n6])));
            this.encodeBits(n5, 2);
        }
        n6 = 0;
        if ((this.mMode & 0x800) == 0) {
            for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
                if (this.mTHConfiguration[this.mGraphAtom[n5]] == 0 || this.mTHConfiguration[this.mGraphAtom[n5]] == 3) continue;
                ++n6;
            }
        }
        this.encodeBits(n6, n9);
        if ((this.mMode & 0x800) == 0) {
            for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
                if (this.mTHConfiguration[this.mGraphAtom[n5]] == 0 || this.mTHConfiguration[this.mGraphAtom[n5]] == 3) continue;
                this.encodeBits(n5, n9);
                if (this.mTHESRType[this.mGraphAtom[n5]] == 0) {
                    this.encodeBits(this.mTHConfiguration[this.mGraphAtom[n5]], 3);
                    continue;
                }
                n4 = this.mTHConfiguration[this.mGraphAtom[n5]] == 1 ? (this.mTHESRType[this.mGraphAtom[n5]] == 1 ? 4 : 6) : (this.mTHESRType[this.mGraphAtom[n5]] == 1 ? 5 : 7);
                this.encodeBits(n4, 3);
                this.encodeBits(this.mTHESRGroup[this.mGraphAtom[n5]], 3);
            }
        }
        n5 = 0;
        if ((this.mMode & 0x800) == 0) {
            for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
                if (this.mEZConfiguration[this.mGraphBond[n4]] == 0 || this.mEZConfiguration[this.mGraphBond[n4]] == 3 || this.mMol.isSmallRingBond(this.mGraphBond[n4]) && this.mMol.getBondType(this.mGraphBond[n4]) != 1) continue;
                ++n5;
            }
        }
        this.encodeBits(n5, n9);
        if ((this.mMode & 0x800) == 0) {
            for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
                if (this.mEZConfiguration[this.mGraphBond[n4]] == 0 || this.mEZConfiguration[this.mGraphBond[n4]] == 3 || this.mMol.isSmallRingBond(this.mGraphBond[n4]) && this.mMol.getBondType(this.mGraphBond[n4]) != 1) continue;
                this.encodeBits(n4, n9);
                if (this.mMol.getBondType(this.mGraphBond[n4]) == 1) {
                    if (this.mEZESRType[this.mGraphBond[n4]] == 0) {
                        this.encodeBits(this.mEZConfiguration[this.mGraphBond[n4]], 3);
                        continue;
                    }
                    n3 = this.mEZConfiguration[this.mGraphBond[n4]] == 1 ? (this.mEZESRType[this.mGraphBond[n4]] == 1 ? 4 : 6) : (this.mEZESRType[this.mGraphBond[n4]] == 1 ? 5 : 7);
                    this.encodeBits(n3, 3);
                    this.encodeBits(this.mEZESRGroup[this.mGraphBond[n4]], 3);
                    continue;
                }
                this.encodeBits(this.mEZConfiguration[this.mGraphBond[n4]], 2);
            }
        }
        this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
        n4 = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            if (this.mMol.getAtomMass(this.mGraphAtom[n3]) == 0) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeFeatureNo(1);
            this.encodeBits(n4, n9);
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (this.mMol.getAtomMass(this.mGraphAtom[n3]) == 0) continue;
                this.encodeBits(n3, n9);
                this.encodeBits(this.mMol.getAtomMass(this.mGraphAtom[n3]), 8);
            }
        }
        this.mFeatureBlock = 0;
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(0, n9, 2048L, 1, -1);
            this.addAtomQueryFeatures(3, n9, 4096L, 1, -1);
            this.addAtomQueryFeatures(4, n9, 120L, 4, 3);
            this.addAtomQueryFeatures(5, n9, 0x400000000006L, 2, 1);
            this.addAtomQueryFeatures(6, n9, 1L, 1, -1);
            this.addAtomQueryFeatures(7, n9, 1920L, 4, 7);
            n4 = 0;
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (this.mMol.getAtomList(this.mGraphAtom[n3]) == null) continue;
                ++n4;
            }
            if (n4 > 0) {
                this.encodeFeatureNo(8);
                this.encodeBits(n4, n9);
                for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                    int[] nArray = this.mMol.getAtomList(this.mGraphAtom[n3]);
                    if (nArray == null) continue;
                    this.encodeBits(n3, n9);
                    this.encodeBits(nArray.length, 4);
                    object = nArray;
                    int n15 = ((Object)object).length;
                    for (n2 = 0; n2 < n15; ++n2) {
                        Object object2 = object[n2];
                        this.encodeBits((long)object2, 8);
                    }
                }
            }
            this.addBondQueryFeatures(9, n9, 384, 2, 7);
            this.addBondQueryFeatures(10, n9, 31, 5, 0);
            this.addAtomQueryFeatures(11, n9, 8192L, 1, -1);
            this.addBondQueryFeatures(12, n9, 130560, 8, 9);
            this.addAtomQueryFeatures(13, n9, 114688L, 3, 14);
            this.addAtomQueryFeatures(14, n9, 0x3E0000L, 5, 17);
            this.addAtomQueryFeatures(16, n9, 0x1C00000L, 3, 22);
        }
        n4 = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            if (this.mAbnormalValence == null || this.mAbnormalValence[this.mGraphAtom[n3]] == -1) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeFeatureNo(17);
            this.encodeBits(n4, n9);
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (this.mAbnormalValence == null || this.mAbnormalValence[this.mGraphAtom[n3]] == -1) continue;
                this.encodeBits(n3, n9);
                this.encodeBits(this.mAbnormalValence[this.mGraphAtom[n3]], 4);
            }
        }
        if ((this.mMode & 8) != 0 || (this.mMode & 0x400) != 0) {
            int n16;
            n4 = 0;
            n3 = 0;
            for (n16 = 0; n16 < this.mMol.getAtoms(); ++n16) {
                object = this.mMol.getAtomCustomLabel(this.mGraphAtom[n16]);
                if (object == null) continue;
                ++n4;
                n3 = Math.max(n3, ((String)object).length());
            }
            if (n4 != 0) {
                n16 = Canonizer.getNeededBits(n3);
                this.encodeFeatureNo(18);
                this.encodeBits(n4, n9);
                this.encodeBits(n16, 4);
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    String string = this.mMol.getAtomCustomLabel(this.mGraphAtom[i]);
                    if (string == null) continue;
                    this.encodeBits(i, n9);
                    this.encodeBits(string.length(), n16);
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        this.encodeBits(string.charAt(n2), 7);
                    }
                }
            }
        }
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(19, n9, 0xE000000L, 3, 25);
            this.addBondQueryFeatures(20, n9, 917504, 3, 17);
        }
        n4 = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            if (this.mMol.getAtomRadical(this.mGraphAtom[n3]) == 0) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeFeatureNo(21);
            this.encodeBits(n4, n9);
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (this.mMol.getAtomRadical(this.mGraphAtom[n3]) == 0) continue;
                this.encodeBits(n3, n9);
                this.encodeBits(this.mMol.getAtomRadical(this.mGraphAtom[n3]) >> 4, 2);
            }
        }
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(22, n9, 0x10000000L, 1, -1);
            this.addBondQueryFeatures(23, n9, 0x100000, 1, -1);
            this.addBondQueryFeatures(24, n9, 0x600000, 2, 21);
        }
        if ((this.mMode & 0x10) != 0) {
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (!this.mMol.isSelectedAtom(this.mGraphAtom[n3])) continue;
                this.encodeFeatureNo(25);
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    this.encodeBits(this.mMol.isSelectedAtom(this.mGraphAtom[i]) ? 1L : 0L, 1);
                }
                break;
            }
        }
        if ((blArray = this.getAromaticSPBonds()) != null) {
            int n17;
            n4 = 0;
            for (n17 = 0; n17 < this.mMol.getBonds(); ++n17) {
                if (!blArray[this.mGraphBond[n17]]) continue;
                ++n4;
            }
            this.encodeFeatureNo(26);
            this.encodeBits(n4, n9);
            for (n17 = 0; n17 < this.mMol.getBonds(); ++n17) {
                if (!blArray[this.mGraphBond[n17]]) continue;
                this.encodeBits(n17, n9);
            }
        }
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(27, n9, 0x20000000L, 1, -1);
        }
        n4 = 0;
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(this.mGraphBond[n]) != 32) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeFeatureNo(28);
            this.encodeBits(n4, n9);
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                if (this.mMol.getBondType(this.mGraphBond[n]) != 32) continue;
                this.encodeBits(n, n9);
            }
        }
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(29, n9, 0xC0000000L, 2, 30);
            this.addAtomQueryFeatures(30, n9, 0x7F00000000L, 7, 32);
            this.addAtomQueryFeatures(32, n9, 0x300000000000L, 2, 44);
            this.addAtomQueryFeatures(33, n9, 0xF8000000000L, 5, 39);
            this.addAtomQueryFeatures(34, n9, 0x400000000000L, 1, -1);
            this.addBondQueryFeatures(35, n9, 0x800000, 1, -1);
            this.addBondQueryFeatures(36, n9, 96, 2, 5);
        }
        n4 = 0;
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(this.mGraphBond[n]) != 8 && this.mMol.getBondType(this.mGraphBond[n]) != 16) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeFeatureNo(37);
            this.encodeBits(n4, n9);
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                if (this.mMol.getBondType(this.mGraphBond[n]) != 8 && this.mMol.getBondType(this.mGraphBond[n]) != 16) continue;
                this.encodeBits(n, n9);
                this.encodeBits(this.mMol.getBondType(this.mGraphBond[n]) == 8 ? 0L : 1L, 1);
            }
        }
        this.encodeBits(0L, 1);
        this.mIDCode = this.encodeBitsEnd();
    }

    private void addAtomQueryFeatures(int n, int n2, long l, int n3, int n4) {
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            if ((this.mMol.getAtomQueryFeatures(this.mGraphAtom[n5]) & l) == 0L) continue;
            ++n6;
        }
        if (n6 == 0) {
            return;
        }
        this.encodeFeatureNo(n);
        this.encodeBits(n6, n2);
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            long l2 = this.mMol.getAtomQueryFeatures(this.mGraphAtom[n5]) & l;
            if (l2 == 0L) continue;
            this.encodeBits(n5, n2);
            if (n3 == 1) continue;
            this.encodeBits(l2 >> n4, n3);
        }
    }

    private void addBondQueryFeatures(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
            if ((this.mMol.getBondQueryFeatures(this.mGraphBond[n6]) & n3) == 0) continue;
            ++n7;
        }
        if (n7 == 0) {
            return;
        }
        this.encodeFeatureNo(n);
        this.encodeBits(n7, n2);
        for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
            int n8 = this.mMol.getBondQueryFeatures(this.mGraphBond[n6]) & n3;
            if (n8 == 0) continue;
            this.encodeBits(n6, n2);
            if (n4 == 1) continue;
            this.encodeBits(n8 >> n5, n4);
        }
    }

    private boolean[] getAromaticSPBonds() {
        boolean[] blArray = null;
        RingCollection ringCollection = this.mMol.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int n;
            int[] nArray;
            if (!ringCollection.isDelocalized(i)) continue;
            int n2 = 0;
            for (int n3 : nArray = ringCollection.getRingAtoms(i)) {
                if (!this.hasTwoAromaticPiElectrons(n3)) continue;
                ++n2;
            }
            if (n2 == 0) continue;
            int[] nArray2 = ringCollection.getRingBonds(i);
            if (blArray == null) {
                blArray = new boolean[this.mMol.getBonds()];
            }
            if (n2 == nArray.length) {
                n = -1;
                int n4 = Integer.MAX_VALUE;
                for (int n3 = 0; n3 < nArray.length; ++n3) {
                    if (n4 <= this.mGraphAtom[nArray2[n3]]) continue;
                    n4 = this.mGraphAtom[nArray2[n3]];
                    n = n3;
                }
                while (n2 > 0) {
                    blArray[nArray2[n]] = true;
                    n = this.validateCyclicIndex(n + 2, nArray.length);
                    n2 -= 2;
                }
                continue;
            }
            n = 0;
            while (this.hasTwoAromaticPiElectrons(nArray[n])) {
                ++n;
            }
            while (!this.hasTwoAromaticPiElectrons(nArray[n])) {
                n = this.validateCyclicIndex(n + 1, nArray.length);
            }
            while (n2 > 0) {
                blArray[nArray2[n]] = true;
                n = this.validateCyclicIndex(n + 2, nArray.length);
                n2 -= 2;
                while (!this.hasTwoAromaticPiElectrons(nArray[n])) {
                    n = this.validateCyclicIndex(n + 1, nArray.length);
                }
            }
        }
        return blArray;
    }

    private boolean hasTwoAromaticPiElectrons(int n) {
        if (this.mMol.getAtomPi(n) < 2) {
            return false;
        }
        if (this.mMol.getConnAtoms(n) == 2) {
            return true;
        }
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3 = this.mMol.getConnBond(n, i);
            if (!this.mMol.isAromaticBond(n3)) continue;
            n2 += this.mMol.getBondOrder(n3) - 1;
        }
        return n2 > 1;
    }

    private int validateCyclicIndex(int n, int n2) {
        return n < n2 ? n : n - n2;
    }

    public void invalidateCoordinates() {
        this.mEncodedCoords = null;
    }

    public String getEncodedCoordinates() {
        return this.getEncodedCoordinates(this.mZCoordinatesAvailable);
    }

    public String getEncodedCoordinates(boolean bl) {
        if (this.mEncodedCoords == null) {
            this.generateGraph();
            this.encodeCoordinates(bl, this.mMol.getAtomCoordinates());
        }
        return this.mEncodedCoords;
    }

    public String getEncodedCoordinates(boolean bl, Coordinates[] coordinatesArray) {
        if (this.mEncodedCoords == null) {
            this.generateGraph();
            this.encodeCoordinates(bl, coordinatesArray);
        }
        return this.mEncodedCoords;
    }

    private void encodeCoordinates(boolean bl, Coordinates[] coordinatesArray) {
        int n;
        int n2;
        int n3;
        if (this.mMol.getAtoms() == 0) {
            this.mEncodedCoords = "";
            return;
        }
        boolean bl2 = false;
        if (this.mZCoordinatesAvailable && this.mMol.getAllAtoms() > this.mMol.getAtoms() && !this.mMol.isFragment()) {
            bl2 = true;
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (this.mMol.getImplicitHydrogens(n3) == 0) continue;
                bl2 = false;
                break;
            }
        }
        n3 = this.mZCoordinatesAvailable ? 16 : 8;
        this.encodeBitsStart(true);
        this.mEncodingBuffer.append(bl2 ? (char)'#' : '!');
        this.encodeBits(this.mZCoordinatesAvailable ? 1L : 0L, 1);
        this.encodeBits(bl ? 1L : 0L, 1);
        this.encodeBits(n3 / 2, 4);
        double d = 0.0;
        for (n2 = 1; n2 < this.mMol.getAtoms(); ++n2) {
            d = this.getMaxDelta(this.mGraphAtom[n2], this.mGraphFrom[n2] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[n2]], d, coordinatesArray);
        }
        if (bl2) {
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                int n4 = this.mGraphAtom[n2];
                for (int i = this.mMol.getConnAtoms(n4); i < this.mMol.getAllConnAtoms(n4); ++i) {
                    d = this.getMaxDelta(this.mMol.getConnAtom(n4, i), n4, d, coordinatesArray);
                }
            }
        }
        if (this.mMol.getAtoms() > 1 && d == 0.0) {
            this.mEncodedCoords = "";
            return;
        }
        n2 = 1 << n3;
        double d2 = d / ((double)n2 / 2.0 - 1.0);
        double d3 = d + d2 / 2.0;
        for (n = 1; n < this.mMol.getAtoms(); ++n) {
            this.encodeCoords(this.mGraphAtom[n], this.mGraphFrom[n] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[n]], d3, d2, n3, coordinatesArray);
        }
        if (bl2) {
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                int n5 = this.mGraphAtom[n];
                for (int i = this.mMol.getConnAtoms(n5); i < this.mMol.getAllConnAtoms(n5); ++i) {
                    this.encodeCoords(this.mMol.getConnAtom(n5, i), n5, d3, d2, n3, coordinatesArray);
                }
            }
        }
        if (bl) {
            double d4 = this.mZCoordinatesAvailable ? 1.5 : Molecule.getDefaultAverageBondLength();
            double d5 = this.mMol.getAverageBondLength(bl2 ? this.mMol.getAllAtoms() : this.mMol.getAtoms(), bl2 ? this.mMol.getAllBonds() : this.mMol.getBonds(), d4, coordinatesArray);
            this.encodeBits(this.encodeABVL(d5, n2), n3);
            this.encodeBits(this.encodeShift(coordinatesArray[this.mGraphAtom[0]].x / d5, n2), n3);
            this.encodeBits(this.encodeShift(coordinatesArray[this.mGraphAtom[0]].y / d5, n2), n3);
            if (this.mZCoordinatesAvailable) {
                this.encodeBits(this.encodeShift(coordinatesArray[this.mGraphAtom[0]].z / d5, n2), n3);
            }
        }
        this.mEncodedCoords = this.encodeBitsEnd();
    }

    private double getMaxDelta(int n, int n2, double d, Coordinates[] coordinatesArray) {
        double d2;
        double d3;
        double d4 = d3 = n2 == -1 ? Math.abs(coordinatesArray[n].x - coordinatesArray[this.mGraphAtom[0]].x) / 8.0 : Math.abs(coordinatesArray[n].x - coordinatesArray[n2].x);
        if (d < d3) {
            d = d3;
        }
        double d5 = d2 = n2 == -1 ? Math.abs(coordinatesArray[n].y - coordinatesArray[this.mGraphAtom[0]].y) / 8.0 : Math.abs(coordinatesArray[n].y - coordinatesArray[n2].y);
        if (d < d2) {
            d = d2;
        }
        if (this.mZCoordinatesAvailable) {
            double d6;
            double d7 = d6 = n2 == -1 ? Math.abs(coordinatesArray[n].z - coordinatesArray[this.mGraphAtom[0]].z) / 8.0 : Math.abs(coordinatesArray[n].z - coordinatesArray[n2].z);
            if (d < d6) {
                d = d6;
            }
        }
        return d;
    }

    private void encodeCoords(int n, int n2, double d, double d2, int n3, Coordinates[] coordinatesArray) {
        double d3 = n2 == -1 ? (coordinatesArray[n].x - coordinatesArray[this.mGraphAtom[0]].x) / 8.0 : coordinatesArray[n].x - coordinatesArray[n2].x;
        double d4 = n2 == -1 ? (coordinatesArray[n].y - coordinatesArray[this.mGraphAtom[0]].y) / 8.0 : coordinatesArray[n].y - coordinatesArray[n2].y;
        this.encodeBits((int)((d + d3) / d2), n3);
        this.encodeBits((int)((d + d4) / d2), n3);
        if (this.mZCoordinatesAvailable) {
            double d5 = n2 == -1 ? (coordinatesArray[n].z - coordinatesArray[this.mGraphAtom[0]].z) / 8.0 : coordinatesArray[n].z - coordinatesArray[n2].z;
            this.encodeBits((int)((d + d5) / d2), n3);
        }
    }

    private int encodeABVL(double d, int n) {
        return Math.min(n - 1, Math.max(0, (int)(0.5 + Math.log10(d / 0.1) / Math.log10(2000.0) * (double)(n - 1))));
    }

    private int encodeShift(double d, int n) {
        int n2 = n / 2;
        boolean bl = d < 0.0;
        d = Math.abs(d);
        double d2 = n / 32;
        int n3 = Math.min(n2 - 1, (int)Math.round(d * (double)n2 / (d + d2)));
        return bl ? n2 + n3 : n3;
    }

    public String getEncodedMapping() {
        if (this.mMapping == null) {
            this.generateGraph();
            this.encodeMapping();
        }
        return this.mMapping;
    }

    private void encodeMapping() {
        int n;
        if (this.mMol.getAtoms() == 0) {
            this.mMapping = "";
            return;
        }
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (n2 < this.mMol.getAtomMapNo(n)) {
                n2 = this.mMol.getAtomMapNo(n);
            }
            if (this.mMol.isAutoMappedAtom(n)) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (n2 == 0) {
            this.mMapping = "";
            return;
        }
        n = Canonizer.getNeededBits(n2);
        this.encodeBitsStart(true);
        this.encodeBits(n, 4);
        this.encodeBits(bl ? 1L : 0L, 1);
        this.encodeBits(bl2 ? 1L : 0L, 1);
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            this.encodeBits(this.mMol.getAtomMapNo(this.mGraphAtom[i]), n);
            if (!bl || !bl2) continue;
            this.encodeBits(this.mMol.isAutoMappedAtom(this.mGraphAtom[i]) ? 1L : 0L, 1);
        }
        this.mMapping = this.encodeBitsEnd();
    }

    private void idGenerateConfigurations() {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        this.mTHConfiguration = new byte[this.mMol.getAtoms()];
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            if (this.mTHParity[n4] == 1 || this.mTHParity[n4] == 2) {
                int n5;
                bl = this.mTHParityIsMesoInverted[n4];
                if (this.mMol.isCentralAlleneAtom(n4)) {
                    for (n3 = 0; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                        n2 = this.mMol.getConnAtom(n4, n3);
                        n5 = 0;
                        int[] nArray = new int[3];
                        for (n = 0; n < this.mMol.getConnAtoms(n2); ++n) {
                            nArray[n5] = this.mMol.getConnAtom(n2, n);
                            if (nArray[n5] == n4) continue;
                            ++n5;
                        }
                        if (n5 != 2 || !(this.mCanRank[nArray[0]] > this.mCanRank[nArray[1]] ^ this.mGraphIndex[nArray[0]] < this.mGraphIndex[nArray[1]])) continue;
                        bl = !bl;
                    }
                } else {
                    for (n3 = 1; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            int n6;
                            n5 = this.mMol.getConnAtom(n4, n3);
                            if (this.mCanRank[n5] > this.mCanRank[n6 = this.mMol.getConnAtom(n4, n2)]) {
                                boolean bl2 = bl = !bl;
                            }
                            if (this.mGraphIndex[n5] >= this.mGraphIndex[n6]) continue;
                            bl = !bl;
                        }
                    }
                }
                this.mTHConfiguration[n4] = this.mTHParity[n4] == 1 ^ bl ? 1 : 2;
                continue;
            }
            this.mTHConfiguration[n4] = this.mTHParity[n4];
        }
        this.mEZConfiguration = new byte[this.mMol.getBonds()];
        for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
            if (this.mEZParity[n4] == 1 || this.mEZParity[n4] == 2) {
                bl = false;
                for (n3 = 0; n3 < 2; ++n3) {
                    n2 = this.mMol.getBondAtom(n3, n4);
                    if (this.mMol.getConnAtoms(n2) != 3) continue;
                    int[] nArray = new int[2];
                    int n7 = 0;
                    for (n = 0; n < 3; ++n) {
                        if (this.mMol.getConnAtom(n2, n) == this.mMol.getBondAtom(1 - n3, n4)) continue;
                        nArray[n7++] = this.mMol.getConnAtom(n2, n);
                    }
                    if (this.mCanRank[nArray[0]] > this.mCanRank[nArray[1]]) {
                        boolean bl3 = bl = !bl;
                    }
                    if (this.mGraphIndex[nArray[0]] >= this.mGraphIndex[nArray[1]]) continue;
                    bl = !bl;
                }
                this.mEZConfiguration[n4] = this.mEZParity[n4] == 1 ^ bl ? 1 : 2;
                continue;
            }
            this.mEZConfiguration[n4] = this.mEZParity[n4];
        }
    }

    private void idNormalizeESRGroupNumbers() {
        this.idNormalizeESRGroupNumbers(1);
        this.idNormalizeESRGroupNumbers(2);
    }

    private void idNormalizeESRGroupNumbers(int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[32];
        int n5 = 0;
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            if (this.mTHConfiguration[n4] != 1 && this.mTHConfiguration[n4] != 2 || this.mTHESRType[n4] != n || nArray[n3 = this.mTHESRGroup[n4]] >= this.mCanRank[n4]) continue;
            if (nArray[n3] == 0) {
                ++n5;
            }
            nArray[n3] = this.mCanRank[n4];
        }
        for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
            if (this.mEZConfiguration[n4] != 1 && this.mEZConfiguration[n4] != 2 || this.mEZESRType[n4] != n || this.mMol.getBondType(n4) != 1 || nArray[n3 = this.mEZESRGroup[n4]] >= (n2 = Math.max(this.mCanRank[this.mMol.getBondAtom(0, n4)], this.mCanRank[this.mMol.getBondAtom(1, n4)]))) continue;
            if (nArray[n3] == 0) {
                ++n5;
            }
            nArray[n3] = n2;
        }
        byte[] byArray = new byte[32];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = -1;
            int n6 = 0;
            for (int i = 0; i < 32; ++i) {
                if (n6 >= nArray[i]) continue;
                n6 = nArray[i];
                n2 = i;
            }
            nArray[n2] = 0;
            byArray[n2] = (byte)n3;
        }
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            if (this.mTHConfiguration[n3] != 1 && this.mTHConfiguration[n3] != 2 || this.mTHESRType[n3] != n) continue;
            this.mTHESRGroup[n3] = byArray[this.mTHESRGroup[n3]];
        }
        for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
            if (this.mEZConfiguration[n3] != 1 && this.mEZConfiguration[n3] != 2 || this.mEZESRType[n3] != n || this.mMol.getBondType(n3) != 1) continue;
            this.mEZESRGroup[n3] = byArray[this.mEZESRGroup[n3]];
        }
    }

    private void encodeBitsStart(boolean bl) {
        this.mEncodingBuffer = new StringBuilder();
        this.mEncodingBitsAvail = 6;
        this.mEncodingTempData = 0;
        this.mEncodeAvoid127 = bl;
    }

    private void encodeFeatureNo(int n) {
        for (int i = 0; i < this.mFeatureBlock; ++i) {
            n -= 16;
        }
        if (n < 0) {
            System.out.println("ERROR in Canonizer: Code unexpectedly low.");
        }
        while (n > 15) {
            this.encodeBits(1L, 1);
            this.encodeBits(15L, 4);
            n -= 16;
            ++this.mFeatureBlock;
        }
        this.encodeBits(1L, 1);
        this.encodeBits(n, 4);
    }

    private void encodeBits(long l, int n) {
        while (n != 0) {
            if (this.mEncodingBitsAvail == 0) {
                if (!this.mEncodeAvoid127 || this.mEncodingTempData != 63) {
                    this.mEncodingTempData += 64;
                }
                this.mEncodingBuffer.append((char)this.mEncodingTempData);
                this.mEncodingBitsAvail = 6;
                this.mEncodingTempData = 0;
            }
            this.mEncodingTempData <<= 1;
            this.mEncodingTempData = (int)((long)this.mEncodingTempData | l & 1L);
            l >>= 1;
            --n;
            --this.mEncodingBitsAvail;
        }
    }

    private String encodeBitsEnd() {
        this.mEncodingTempData <<= this.mEncodingBitsAvail;
        if (!this.mEncodeAvoid127 || this.mEncodingTempData != 63) {
            this.mEncodingTempData += 64;
        }
        this.mEncodingBuffer.append((char)this.mEncodingTempData);
        return this.mEncodingBuffer.toString();
    }

    public static int getNeededBits(int n) {
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    public int getTHParity(int n) {
        return this.mTHParity[n];
    }

    public int getEZParity(int n) {
        return this.mEZParity[n];
    }

    public int getPseudoStereoGroupCount() {
        return this.mNoOfPseudoGroups;
    }

    public int getPseudoEZGroup(int n) {
        return this.mPseudoEZGroup[n];
    }

    public int getPseudoTHGroup(int n) {
        return this.mPseudoTHGroup[n];
    }

    public boolean normalizeEnantiomer() {
        int n;
        int[] nArray = new int[this.mNoOfRanks + 1];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mMol.getAtomESRType(n) != 0) continue;
            if (this.mTHParity[n] == 1) {
                int n2 = this.mCanRank[n];
                nArray[n2] = nArray[n2] + 1;
                continue;
            }
            if (this.mTHParity[n] != 2) continue;
            int n3 = this.mCanRank[n];
            nArray[n3] = nArray[n3] - 1;
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondOrder(n) != 1 || this.mMol.getBondESRType(n) != 0) continue;
            if (this.mEZParity[n] == 1) {
                int n4 = this.mCanRank[this.mMol.getBondAtom(0, n)];
                nArray[n4] = nArray[n4] + 1;
                int n5 = this.mCanRank[this.mMol.getBondAtom(1, n)];
                nArray[n5] = nArray[n5] + 1;
                continue;
            }
            if (this.mEZParity[n] != 2) continue;
            int n6 = this.mCanRank[this.mMol.getBondAtom(0, n)];
            nArray[n6] = nArray[n6] - 1;
            int n7 = this.mCanRank[this.mMol.getBondAtom(1, n)];
            nArray[n7] = nArray[n7] - 1;
        }
        for (n = 1; n <= this.mNoOfRanks; ++n) {
            boolean bl;
            if (nArray[n] == 0) continue;
            boolean bl2 = bl = nArray[n] < 0;
            if (bl) {
                int n8;
                for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
                    if (this.mMol.getAtomESRType(n8) != 0) continue;
                    if (this.mTHParity[n8] == 1) {
                        this.mTHParity[n8] = 2;
                        continue;
                    }
                    if (this.mTHParity[n8] != 2) continue;
                    this.mTHParity[n8] = 1;
                }
                for (n8 = 0; n8 < this.mMol.getBonds(); ++n8) {
                    if (this.mMol.getBondOrder(n8) != 1 || this.mMol.getBondESRType(n8) != 0) continue;
                    if (this.mEZParity[n8] == 1) {
                        this.mEZParity[n8] = 2;
                        continue;
                    }
                    if (this.mEZParity[n8] != 2) continue;
                    this.mEZParity[n8] = 1;
                }
            }
            return bl;
        }
        return false;
    }

    public void setParities() {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            if (this.mTHParity[n4] == 1 || this.mTHParity[n4] == 2) {
                int n5;
                bl = false;
                if (this.mMol.isCentralAlleneAtom(n4)) {
                    for (n3 = 0; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                        n2 = this.mMol.getConnAtom(n4, n3);
                        n5 = 0;
                        int[] nArray = new int[3];
                        for (n = 0; n < this.mMol.getConnAtoms(n2); ++n) {
                            nArray[n5] = this.mMol.getConnAtom(n2, n);
                            if (nArray[n5] == n4) continue;
                            ++n5;
                        }
                        if (n5 != 2 || !(this.mCanRank[nArray[0]] > this.mCanRank[nArray[1]] ^ nArray[0] < nArray[1])) continue;
                        bl = !bl;
                    }
                } else {
                    for (n3 = 1; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            int n6;
                            n5 = this.mMol.getConnAtom(n4, n3);
                            if (this.mCanRank[n5] > this.mCanRank[n6 = this.mMol.getConnAtom(n4, n2)]) {
                                boolean bl2 = bl = !bl;
                            }
                            if (n5 >= n6) continue;
                            bl = !bl;
                        }
                    }
                }
                this.mMol.setAtomParity(n4, this.mTHParity[n4] == 1 ^ bl ? 1 : 2, this.mTHParityIsPseudo[n4]);
                continue;
            }
            this.mMol.setAtomParity(n4, this.mTHParity[n4], this.mTHParityIsPseudo[n4]);
        }
        for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
            if (this.mEZParity[n4] == 1 || this.mEZParity[n4] == 2) {
                bl = false;
                for (n3 = 0; n3 < 2; ++n3) {
                    n2 = this.mMol.getBondAtom(n3, n4);
                    if (this.mMol.getConnAtoms(n2) != 3) continue;
                    int[] nArray = new int[2];
                    int n7 = 0;
                    for (n = 0; n < 3; ++n) {
                        if (this.mMol.getConnAtom(n2, n) == this.mMol.getBondAtom(1 - n3, n4)) continue;
                        nArray[n7++] = this.mMol.getConnAtom(n2, n);
                    }
                    if (this.mCanRank[nArray[0]] > this.mCanRank[nArray[1]]) {
                        boolean bl3 = bl = !bl;
                    }
                    if (nArray[0] >= nArray[1]) continue;
                    bl = !bl;
                }
                this.mMol.setBondParity(n4, this.mEZParity[n4] == 1 ^ bl ? 1 : 2, this.mEZParityIsPseudo[n4]);
                continue;
            }
            this.mMol.setBondParity(n4, this.mEZParity[n4], this.mEZParityIsPseudo[n4]);
        }
    }

    protected void setStereoCenters() {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            this.mMol.setAtomStereoCenter(i, this.mIsStereoCenter[i]);
        }
    }

    protected void setCIPParities() {
        int n;
        if (this.mTHCIPParity != null) {
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                this.mMol.setAtomCIPParity(n, this.mTHCIPParity[n]);
            }
        }
        if (this.mEZCIPParity != null) {
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                this.mMol.setBondCIPParity(n, this.mEZCIPParity[n]);
            }
        }
    }

    private void cipCalcTHParity(int n) {
        if (this.mTHParity[n] == 1 || this.mTHParity[n] == 2) {
            int[] nArray;
            boolean bl = false;
            if (this.mMol.getAtomPi(n) == 2) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        int n2 = this.mMol.getConnAtom(n, i);
                        if (this.mMol.getConnAtoms(n2) != 3) continue;
                        int[] nArray2 = new int[2];
                        int n3 = 0;
                        for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                            if (this.mMol.getConnBondOrder(n2, j) != 1) continue;
                            nArray2[n3++] = this.mMol.getConnAtom(n2, j);
                        }
                        if (!(this.mCanRank[nArray2[0]] > this.mCanRank[nArray2[1]] ^ this.cipComparePriority(n2, nArray2[0], nArray2[1]))) continue;
                        bl = !bl;
                    }
                }
                catch (Exception exception) {
                    this.mTHCIPParity[n] = 3;
                    return;
                }
            }
            try {
                nArray = this.cipGetOrderedConns(n);
            }
            catch (Exception exception) {
                this.mTHCIPParity[n] = 3;
                return;
            }
            for (int i = 1; i < nArray.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.mCanRank[nArray[i]] >= this.mCanRank[nArray[j]]) continue;
                    bl = !bl;
                }
            }
            this.mTHCIPParity[n] = this.mTHParity[n] == 1 ^ bl ? 1 : 2;
        }
    }

    private void cipCalcEZParity(int n) {
        if (!(this.mEZParity[n] != 1 && this.mEZParity[n] != 2 || this.mMol.isSmallRingBond(n))) {
            boolean bl = false;
            try {
                for (int i = 0; i < 2; ++i) {
                    int n2 = this.mMol.getBondAtom(i, n);
                    if (this.mMol.getConnAtoms(n2) != 3) continue;
                    int[] nArray = new int[2];
                    int n3 = 0;
                    for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                        if (this.mMol.getConnBond(n2, j) == n) continue;
                        nArray[n3++] = this.mMol.getConnAtom(n2, j);
                    }
                    if (!(this.mCanRank[nArray[0]] > this.mCanRank[nArray[1]] ^ this.cipComparePriority(n2, nArray[0], nArray[1]))) continue;
                    bl = !bl;
                }
            }
            catch (Exception exception) {
                this.mEZCIPParity[n] = 3;
                return;
            }
            this.mEZCIPParity[n] = this.mEZParity[n] == 1 ^ bl ? 1 : 2;
        }
    }

    private int[] cipGetOrderedConns(int n) throws Exception {
        int n2;
        int n3 = this.mMol.getAllConnAtoms(n);
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = this.mMol.getConnAtom(n, n2);
        }
        for (n2 = n3; n2 > 1; --n2) {
            boolean bl = false;
            for (int i = 1; i < n2; ++i) {
                if (!this.cipComparePriority(n, nArray[i - 1], nArray[i])) continue;
                bl = true;
                int n4 = nArray[i - 1];
                nArray[i - 1] = nArray[i];
                nArray[i] = n4;
            }
            if (!bl) break;
        }
        return nArray;
    }

    private boolean cipComparePriority(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.mMol.getAtomicNo(n2) != this.mMol.getAtomicNo(n3)) {
            return this.mMol.getAtomicNo(n2) > this.mMol.getAtomicNo(n3);
        }
        if (this.mMol.getAtomMass(n2) != this.mMol.getAtomMass(n3)) {
            int n8 = this.mMol.isNaturalAbundance(n2) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(n2)] : this.mMol.getAtomMass(n2);
            int n9 = this.mMol.isNaturalAbundance(n3) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(n3)] : this.mMol.getAtomMass(n3);
            return n8 > n9;
        }
        int n10 = this.mMol.getAtoms();
        int[] nArray = new int[n10];
        int[] nArray2 = new int[n10];
        int[] nArray3 = new int[n10];
        boolean[] blArray = new boolean[n10];
        boolean[] blArray2 = new boolean[this.mMol.getAllAtoms()];
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray2[0] = -1;
        nArray2[1] = 0;
        nArray2[2] = 0;
        blArray2[n] = true;
        blArray2[n2] = true;
        blArray2[n3] = true;
        int n11 = 1;
        int n12 = 2;
        int[] nArray4 = new int[64];
        nArray4[1] = 1;
        nArray4[2] = 3;
        int n13 = 2;
        while (n11 <= n12) {
            int n14;
            while (n11 < nArray4[n13]) {
                n14 = nArray[n11];
                if (!blArray[n11]) {
                    n7 = 0;
                    n6 = 0;
                    for (n5 = 0; n5 < this.mMol.getConnAtoms(n14); ++n5) {
                        int n15;
                        n4 = this.mMol.getConnAtom(n14, n5);
                        if (n12 + this.mMol.getConnBondOrder(n14, n5) + 1 >= n10) {
                            nArray = this.resize(nArray, n10 += this.mMol.getAtoms());
                            nArray2 = this.resize(nArray2, n10);
                            nArray3 = this.resize(nArray3, n10);
                            blArray = this.resize(blArray, n10);
                        }
                        if (this.mMol.isDelocalizedBond(this.mMol.getConnBond(n14, n5))) {
                            ++n7;
                            n6 += this.mMol.getAtomicNo(n4);
                        } else {
                            for (n15 = 1; n15 < this.mMol.getConnBondOrder(n14, n5); ++n15) {
                                nArray[++n12] = n4;
                                nArray2[n12] = n11;
                                blArray[n12] = true;
                            }
                        }
                        n15 = nArray2[n11];
                        if (n4 == nArray[n15]) continue;
                        boolean bl = false;
                        if (blArray2[n4]) {
                            int n16 = nArray2[n15];
                            while (n16 != -1) {
                                if (n4 == nArray[n16]) {
                                    bl = true;
                                    break;
                                }
                                n16 = nArray2[n16];
                            }
                        }
                        if (bl) {
                            nArray[++n12] = n4;
                            nArray2[n12] = n11;
                            blArray[n12] = true;
                            continue;
                        }
                        nArray[++n12] = n4;
                        nArray2[n12] = n11;
                        blArray2[n4] = true;
                    }
                    if (n7 != 0) {
                        nArray3[++n12] = (n6 << 2) / n7;
                        nArray2[n12] = n11;
                        blArray[n12] = true;
                    }
                }
                if (++n11 != 10000) continue;
                throw new Exception("Emergency break in while loop.");
            }
            if (nArray4.length == n13 + 1) {
                nArray4 = this.resize(nArray4, nArray4.length + 64);
            }
            nArray4[n13 + 1] = n12 + 1;
            for (n14 = nArray4[n13]; n14 < nArray4[n13 + 1]; ++n14) {
                if (nArray3[n14] == 0) {
                    nArray3[n14] = (this.mMol.getAtomicNo(nArray[n14]) == 151 ? 1 : (this.mMol.getAtomicNo(nArray[n14]) == 152 ? 1 : this.mMol.getAtomicNo(nArray[n14]))) << 2;
                }
                int n17 = n14;
                nArray3[n17] = nArray3[n17] + (nArray3[nArray2[n14]] << 16);
            }
            this.cipUpdateParentRanking(blArray, nArray3, nArray2, nArray, nArray4, n13);
            if (nArray3[1] != nArray3[2]) {
                return nArray3[1] > nArray3[2];
            }
            if (n13 > 1) {
                this.cipCompileRelativeRanks(nArray3, nArray2, nArray4, n13);
            }
            ++n13;
        }
        int[] nArray5 = new int[this.mMol.getAtoms()];
        n7 = 0;
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if (!blArray2[n6] || this.mMol.isNaturalAbundance(n6)) continue;
            n7 = 1;
            break;
        }
        if (n7 != 0) {
            for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
                nArray5[n6] = this.mMol.isNaturalAbundance(n6) ? Molecule.cRoundedMass[this.mMol.getAtomicNo(n6)] : this.mMol.getAtomMass(n6);
            }
            if (this.cipTryDistinguishBranches(blArray, nArray3, nArray2, nArray, nArray5, nArray4, n13)) {
                return nArray3[1] > nArray3[2];
            }
        }
        Arrays.fill(nArray5, 0);
        n6 = 0;
        for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
            if (!blArray2[this.mMol.getBondAtom(0, n5)] && !blArray2[this.mMol.getBondAtom(1, n5)]) continue;
            if (this.mEZCIPParity[n5] == 1) {
                nArray5[this.mMol.getBondAtom((int)0, (int)n5)] = 1;
                nArray5[this.mMol.getBondAtom((int)1, (int)n5)] = 1;
                n6 = 1;
                continue;
            }
            if (this.mEZCIPParity[n5] != 2) continue;
            nArray5[this.mMol.getBondAtom((int)0, (int)n5)] = 2;
            nArray5[this.mMol.getBondAtom((int)1, (int)n5)] = 2;
            n6 = 1;
        }
        if (n6 != 0 && this.cipTryDistinguishBranches(blArray, nArray3, nArray2, nArray, nArray5, nArray4, n13)) {
            return nArray3[1] > nArray3[2];
        }
        Arrays.fill(nArray5, 0);
        n5 = 0;
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            if (!blArray2[n4]) continue;
            if (this.mTHCIPParity[n4] == 2) {
                nArray5[n4] = 1;
                n5 = 1;
                continue;
            }
            if (this.mTHCIPParity[n4] != 1) continue;
            nArray5[n4] = 2;
            n5 = 1;
        }
        if (n5 != 0 && this.cipTryDistinguishBranches(blArray, nArray3, nArray2, nArray, nArray5, nArray4, n13)) {
            return nArray3[1] > nArray3[2];
        }
        this.mCIPParityNoDistinctionProblem = true;
        throw new Exception("no distinction applying CIP rules");
    }

    private boolean cipTryDistinguishBranches(boolean[] blArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n) {
        for (int i = 1; i < n; ++i) {
            for (int j = nArray5[i]; j < nArray5[i + 1]; ++j) {
                nArray[j] = nArray4[nArray3[j]] + (nArray[nArray2[j]] << 8);
            }
            this.cipUpdateParentRanking(blArray, nArray, nArray2, nArray3, nArray5, i);
            if (nArray[1] != nArray[2]) {
                return true;
            }
            if (i <= 1) continue;
            this.cipCompileRelativeRanks(nArray, nArray2, nArray5, i);
        }
        return false;
    }

    private int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private boolean[] resize(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    private void cipUpdateParentRanking(boolean[] blArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        for (int i = n; i > 1; --i) {
            int n2;
            int n3;
            int n4 = nArray4[i] - nArray4[i - 1];
            class RankObject {
                int parentIndex;
                int parentRank;
                int parentHCount;
                int[] childRank;

                RankObject() {
                }
            }
            RankObject[] rankObjectArray = new RankObject[n4];
            int n5 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                n3 = nArray4[i - 1] + j;
                for (n2 = n5; n2 < nArray4[i + 1] && nArray2[n2] == n3; ++n2) {
                }
                rankObjectArray[j] = new RankObject();
                rankObjectArray[j].parentIndex = n3;
                rankObjectArray[j].parentRank = nArray[n3];
                rankObjectArray[j].parentHCount = blArray[n3] ? 0 : this.mMol.getPlainHydrogens(nArray3[n3]);
                rankObjectArray[j].childRank = new int[n2 - n5];
                for (int k = n5; k < n2; ++k) {
                    rankObjectArray[j].childRank[k - n5] = nArray[k];
                }
                Arrays.sort(rankObjectArray[j].childRank);
                n5 = n2;
            }
            Comparator<RankObject> comparator = new Comparator<RankObject>(){

                @Override
                public int compare(RankObject rankObject, RankObject rankObject2) {
                    if (rankObject.parentRank != rankObject2.parentRank) {
                        return rankObject.parentRank > rankObject2.parentRank ? 1 : -1;
                    }
                    int n = rankObject.childRank.length;
                    int n2 = rankObject2.childRank.length;
                    int n3 = Math.min(n, n2);
                    for (int i = 0; i < n3; ++i) {
                        if (rankObject.childRank[--n] == rankObject2.childRank[--n2]) continue;
                        return rankObject.childRank[n] > rankObject2.childRank[n2] ? 1 : -1;
                    }
                    if (n != n2) {
                        return n > n2 ? 1 : -1;
                    }
                    if (rankObject.parentHCount != rankObject2.parentHCount) {
                        return rankObject.parentHCount > rankObject2.parentHCount ? 1 : -1;
                    }
                    return 0;
                }
            };
            Arrays.sort(rankObjectArray, comparator);
            n3 = 1;
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[rankObjectArray[n2].parentIndex] = n3++;
                if (n2 != n4 - 1 && comparator.compare(rankObjectArray[n2], rankObjectArray[n2 + 1]) == 0) continue;
            }
        }
    }

    private void cipCompileRelativeRanks(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray3[n];
        int n3 = nArray3[n + 1] - n2;
        class RankObject {
            int rank;
            int parent;
            int index;

            RankObject() {
            }
        }
        RankObject[] rankObjectArray = new RankObject[n3];
        for (int i = 0; i < n3; ++i) {
            rankObjectArray[i] = new RankObject();
            rankObjectArray[i].rank = nArray[i + n2];
            rankObjectArray[i].parent = nArray2[i + n2];
            rankObjectArray[i].index = i + n2;
        }
        Comparator<RankObject> comparator = new Comparator<RankObject>(){

            @Override
            public int compare(RankObject rankObject, RankObject rankObject2) {
                if (rankObject.rank != rankObject2.rank) {
                    return rankObject.rank > rankObject2.rank ? 1 : -1;
                }
                return 0;
            }
        };
        for (int i = n; i > 1; --i) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                rankObjectArray[n4].rank += nArray[rankObjectArray[n4].parent] << 16;
                rankObjectArray[n4].parent = nArray2[rankObjectArray[n4].parent];
            }
            Arrays.sort(rankObjectArray, comparator);
            n4 = 1;
            for (int j = 0; j < n3; ++j) {
                nArray[rankObjectArray[j].index] = n4++;
                if (j != n3 - 1 && comparator.compare(rankObjectArray[j], rankObjectArray[j + 1]) == 0) continue;
            }
        }
    }

    public int[] getGraphAtoms() {
        this.generateGraph();
        return this.mGraphAtom;
    }

    public int[] getGraphIndexes() {
        this.generateGraph();
        return this.mGraphIndex;
    }

    class ESRGroup
    implements Comparable<ESRGroup> {
        int[] atomList;
        int[] rankList;

        protected ESRGroup(int n, int n2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < Canonizer.this.mMol.getAtoms(); ++n3) {
                if (Canonizer.this.mTHESRType[n3] != n || Canonizer.this.mTHESRGroup[n3] != n2) continue;
                ++n4;
            }
            this.atomList = new int[n4];
            this.rankList = new int[n4];
            n4 = 0;
            for (n3 = 0; n3 < Canonizer.this.mMol.getAtoms(); ++n3) {
                if (Canonizer.this.mTHESRType[n3] != n || Canonizer.this.mTHESRGroup[n3] != n2) continue;
                this.atomList[n4] = n3;
                this.rankList[n4++] = Canonizer.this.mCanRank[n3];
            }
            Arrays.sort(this.rankList);
        }

        @Override
        public int compareTo(ESRGroup eSRGroup) {
            if (this.rankList.length != eSRGroup.rankList.length) {
                return this.rankList.length < eSRGroup.rankList.length ? -1 : 1;
            }
            for (int i = 0; i < this.rankList.length; ++i) {
                if (this.rankList[i] == eSRGroup.rankList[i]) continue;
                return this.rankList[i] < eSRGroup.rankList[i] ? -1 : 1;
            }
            return 0;
        }
    }
}

