/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SimpleCanonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.chem.io.SDFileParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.TreeMap;
import java.util.TreeSet;

public class AtomTypeList {
    private static final String VERSION_STRING = "AtomTypeList v1.1";
    private static final int DEFAULT_MIN_ATOMS = 10;
    private static final int DEFAULT_MAX_ATOMS = 50;
    private TreeMap<Long, Integer> mCountList;
    private TreeMap<Long, Double> mProbabilityList;
    private float[] mRingSizeAdjust = new float[8];
    private int mAtomTypeMode;
    private int mMaxAtoms;
    private int mMinAtoms;

    public AtomTypeList(int n) {
        this.mCountList = new TreeMap();
        this.mAtomTypeMode = n;
        this.mMinAtoms = 10;
        this.mMaxAtoms = 50;
    }

    public AtomTypeList(String string, int n) throws Exception {
        this(n);
        DWARFileParser dWARFileParser;
        if (string.endsWith(".typ")) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
            String string3 = bufferedReader.readLine();
            if (!VERSION_STRING.equals(string3)) {
                throw new Exception("Outdated atom type list file.");
            }
            this.mAtomTypeMode = Integer.parseInt(bufferedReader.readLine());
            if (this.mAtomTypeMode != n) {
                throw new Exception("Incompatible atom type mode.");
            }
            for (int i = 0; i < 8; ++i) {
                this.mRingSizeAdjust[i] = Float.parseFloat(bufferedReader.readLine());
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                int n2 = string2.indexOf(9);
                this.mCountList.put(new Long(Long.parseLong(string2.substring(0, n2))), new Integer(Integer.parseInt(string2.substring(n2 + 1))));
            }
            bufferedReader.close();
            return;
        }
        CompoundFileParser compoundFileParser = string.endsWith(".dwar") ? new DWARFileParser(string) : (dWARFileParser = string.endsWith(".sdf") ? new SDFileParser(string) : null);
        if (dWARFileParser != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            try {
                while (dWARFileParser.next()) {
                    this.processMolecule(dWARFileParser.getMolecule(), treeSet);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.finalizeProcessMolecules();
        }
    }

    public void finalizeProcessMolecules() {
        int n;
        float f = 0.0f;
        for (n = 0; n < 8; ++n) {
            f += this.mRingSizeAdjust[n];
        }
        if (f != 0.0f) {
            n = 0;
            while (n < 8) {
                int n2 = n++;
                this.mRingSizeAdjust[n2] = this.mRingSizeAdjust[n2] / f;
            }
        }
    }

    public synchronized void calculateProbabilities() {
        if (this.mProbabilityList == null) {
            int n = 0;
            for (Integer number : this.mCountList.values()) {
                n += number.intValue();
            }
            n /= this.mCountList.size();
            this.mProbabilityList = new TreeMap();
            for (Long l : this.mCountList.keySet()) {
                this.mProbabilityList.put(l, (double)this.mCountList.get(l).intValue() / (double)n);
            }
        }
    }

    public void writeTypeFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(VERSION_STRING);
            bufferedWriter.newLine();
            bufferedWriter.write("" + this.mAtomTypeMode);
            bufferedWriter.newLine();
            for (int i = 0; i < 8; ++i) {
                bufferedWriter.write("" + this.mRingSizeAdjust[i]);
                bufferedWriter.newLine();
            }
            for (Long l : this.mCountList.keySet()) {
                bufferedWriter.write(l.toString() + "\t" + this.mCountList.get(l).toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeTextFile(String string, int n) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("AtomType\tFrequency\t" + AtomTypeCalculator.getHeaderString(n));
            bufferedWriter.newLine();
            for (Long l : this.mCountList.keySet()) {
                bufferedWriter.write(Long.toString(l) + "\t" + this.mCountList.get(l).toString() + "\t" + AtomTypeCalculator.getTypeString(l, n));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TreeMap<Long, Integer> getAtomTypeList() {
        return this.mCountList;
    }

    public void processMolecule(StereoMolecule stereoMolecule, TreeSet<String> treeSet) {
        if (stereoMolecule != null) {
            String string;
            stereoMolecule.stripIsotopInfo();
            stereoMolecule.stripSmallFragments();
            stereoMolecule.stripStereoInformation();
            stereoMolecule.ensureHelperArrays(1);
            boolean bl = false;
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!stereoMolecule.isMetalAtom(i)) continue;
                bl = true;
                break;
            }
            if (!bl && stereoMolecule.getAtoms() >= this.mMinAtoms && stereoMolecule.getAtoms() <= this.mMaxAtoms && !treeSet.contains(string = new SimpleCanonizer(stereoMolecule).getIDCode())) {
                treeSet.add(string);
                for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                    try {
                        this.addAtomType(AtomTypeCalculator.getAtomType(stereoMolecule, i, this.mAtomTypeMode));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                RingCollection ringCollection = stereoMolecule.getRingSet();
                for (int i = 0; i < ringCollection.getSize(); ++i) {
                    int n = ringCollection.getRingSize(i);
                    this.mRingSizeAdjust[n] = this.mRingSizeAdjust[n] + 1.0f;
                }
            }
        }
    }

    private void addAtomType(Long l) {
        Integer n = this.mCountList.get(l);
        if (n == null) {
            this.mCountList.put(l, 1);
        } else {
            this.mCountList.put(l, n + 1);
        }
    }

    public int getCountFromType(long l) {
        return this.mCountList.get(new Long(l));
    }

    public double getProbabilityFromType(long l) {
        return this.mProbabilityList.get(l);
    }

    public float getRingSizeAdjust(int n) {
        return this.mRingSizeAdjust[n];
    }
}

