/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.statistics.median;

import com.actelion.research.util.Formatter;
import com.actelion.research.util.StringFunctions;
import java.util.List;

public class ModelMedianDouble {
    private static final int LENGTH = 7;
    public double lowerQuartile;
    public double median;
    public double upperQuartile;
    public int id;
    public int size;

    public ModelMedianDouble() {
    }

    public ModelMedianDouble(double d, double d2, double d3, int n, int n2) {
        this.lowerQuartile = d;
        this.median = d2;
        this.upperQuartile = d3;
        this.id = n;
        this.size = n2;
    }

    public ModelMedianDouble(ModelMedianDouble modelMedianDouble) {
        this.lowerQuartile = modelMedianDouble.lowerQuartile;
        this.median = modelMedianDouble.median;
        this.upperQuartile = modelMedianDouble.upperQuartile;
        this.id = modelMedianDouble.id;
        this.size = modelMedianDouble.size;
    }

    public double range() {
        return this.upperQuartile - this.lowerQuartile;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Formatter.format4(this.lowerQuartile));
        stringBuilder.append("\t");
        stringBuilder.append(Formatter.format4(this.median));
        stringBuilder.append("\t");
        stringBuilder.append(Formatter.format4(this.upperQuartile));
        return stringBuilder.toString();
    }

    public static String toString(List<ModelMedianDouble> list) {
        String string;
        ModelMedianDouble modelMedianDouble;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 7;
        int n3 = 15;
        stringBuilder.append(StringFunctions.format2DefinedLengthTrailing("Id", n3));
        for (n = 0; n < list.size(); ++n) {
            modelMedianDouble = list.get(n);
            string = StringFunctions.format2DefinedLengthLeading(Integer.toString(modelMedianDouble.id), n2);
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
        stringBuilder.append(StringFunctions.format2DefinedLengthTrailing("Upper quartile", n3));
        for (n = 0; n < list.size(); ++n) {
            modelMedianDouble = list.get(n);
            string = StringFunctions.format2DefinedLengthLeading(Formatter.format2(modelMedianDouble.upperQuartile), n2);
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
        stringBuilder.append(StringFunctions.format2DefinedLengthTrailing("Median", n3));
        for (n = 0; n < list.size(); ++n) {
            modelMedianDouble = list.get(n);
            string = StringFunctions.format2DefinedLengthLeading(Formatter.format2(modelMedianDouble.median), n2);
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
        stringBuilder.append(StringFunctions.format2DefinedLengthTrailing("Lower quartile", n3));
        for (n = 0; n < list.size(); ++n) {
            modelMedianDouble = list.get(n);
            string = StringFunctions.format2DefinedLengthLeading(Formatter.format2(modelMedianDouble.lowerQuartile), n2);
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
        stringBuilder.append(StringFunctions.format2DefinedLengthTrailing("Size", n3));
        for (n = 0; n < list.size(); ++n) {
            modelMedianDouble = list.get(n);
            string = StringFunctions.format2DefinedLengthLeading(Integer.toString(modelMedianDouble.size), n2);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

