/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.statistics;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.histogram.IntegerHistogram;
import com.actelion.research.calc.histogram.MatrixBasedHistogram;
import com.actelion.research.calc.statistics.ModelStatisticsOverview;
import com.actelion.research.calc.statistics.ModelStatisticsOverviewMedian;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.IntArray;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;

public class StatisticsOverview {
    public static final String TAG_MEAN = "Avr";
    public static final String TAG_SDV = "SDV";
    public static final String TAG_MEDIAN = "Median";
    public static final String TAG_PERCENTILE05 = "Percentile.05";
    public static final String TAG_PERCENTILE95 = "Percentile.95";
    public static final NumberFormat DF1 = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    public static final NumberFormat DF3 = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    public static final NumberFormat DF4 = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    private static final NumberFormat DF3Plus = new DecimalFormat("0.000##", new DecimalFormatSymbols(Locale.US));
    private static final int BINS = 20;
    private static final int WIDTH = 8;
    private static final int DIGITS = 2;
    private String name;
    private double min;
    private double mean;
    private double max;
    private double sdv;
    private double percentile05;
    private double leftQuartile;
    private double median;
    private double rightQuartile;
    private double percentile95;
    private Matrix histogram;
    private int valsBelowHistMin;
    private int valsAboveHistMax;
    private int bins;
    private DoubleArray data;
    private boolean evaluated;

    public StatisticsOverview() {
        this.data = new DoubleArray();
        this.bins = 20;
        this.evaluated = false;
    }

    public StatisticsOverview(DoubleArray doubleArray) {
        this.data = doubleArray;
        this.bins = 20;
        this.evaluated = false;
    }

    public void add(double d) {
        this.data.add(d);
        this.evaluated = false;
    }

    public void add(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.data.add(dArray[i]);
        }
        this.evaluated = false;
    }

    public void add(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.add(nArray[i]);
        }
        this.evaluated = false;
    }

    public DoubleArray getData() {
        return this.data;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSdv() {
        return this.sdv;
    }

    public double getMedian() {
        return this.median;
    }

    public ModelStatisticsOverview evaluate() {
        double d = this.data.min() - this.data.min() * 1.0E-6;
        double d2 = this.data.max() + this.data.max() * 1.0E-6;
        ModelStatisticsOverview modelStatisticsOverview = new ModelStatisticsOverview();
        if (Math.abs(d - d2) > 1.0E-8) {
            this.evaluate(d, d2);
            modelStatisticsOverview.min = this.data.min();
            modelStatisticsOverview.avr = this.mean;
            modelStatisticsOverview.max = this.data.max();
            modelStatisticsOverview.sdv = this.sdv;
        } else {
            modelStatisticsOverview.min = 0.0;
            modelStatisticsOverview.avr = 0.0;
            modelStatisticsOverview.max = 0.0;
            modelStatisticsOverview.sdv = 0.0;
        }
        return modelStatisticsOverview;
    }

    public void evaluate(double d, double d2) {
        if (Math.abs(d - d2) < 1.0E-8) {
            throw new RuntimeException("Equal histogram boundaries! histMin " + d + " histMax" + d2 + ".");
        }
        this.calculateMedianStatistics();
        double[] dArray = this.data.get();
        this.min = ArrayUtilsCalc.min(dArray);
        this.mean = ArrayUtilsCalc.getMean(dArray);
        this.max = ArrayUtilsCalc.max(dArray);
        this.sdv = ArrayUtilsCalc.getStandardDeviation(dArray);
        Matrix matrix = MatrixBasedHistogram.getHistogramBins(d, d2, this.bins);
        Matrix matrix2 = new Matrix(true, dArray);
        this.histogram = MatrixBasedHistogram.getHistogram(matrix2, matrix);
        for (int i = 0; i < matrix2.cols(); ++i) {
            if (matrix2.get(0, i) < d) {
                ++this.valsBelowHistMin;
                continue;
            }
            if (!(matrix2.get(0, i) > d2)) continue;
            ++this.valsAboveHistMax;
        }
        this.evaluated = true;
    }

    public void evaluateIntegerBins(double d, double d2) {
        this.calculateMedianStatistics();
        Matrix matrix = new Matrix(true, this.data.get());
        this.mean = matrix.getMean();
        this.sdv = matrix.getStandardDeviation();
        int[][] nArray = IntegerHistogram.getBinsEquallyDistributed(this.bins, (int)d, (int)d2);
        Matrix matrix2 = new Matrix(nArray);
        matrix2 = matrix2.getTranspose();
        this.histogram = MatrixBasedHistogram.getHistogram(matrix, matrix2);
        for (int i = 0; i < matrix.cols(); ++i) {
            if (matrix.get(0, i) < d) {
                ++this.valsBelowHistMin;
                continue;
            }
            if (!(matrix.get(0, i) > d2)) continue;
            ++this.valsAboveHistMax;
        }
        this.evaluated = true;
    }

    private double calculateMedianStatistics() {
        double[] dArray = this.data.get();
        Arrays.sort(dArray);
        this.percentile05 = StatisticsOverview.getQuartile(dArray, 0.05);
        this.leftQuartile = StatisticsOverview.getQuartile(dArray, 0.25);
        this.median = StatisticsOverview.getQuartile(dArray, 0.5);
        this.rightQuartile = StatisticsOverview.getQuartile(dArray, 0.75);
        this.percentile95 = StatisticsOverview.getQuartile(dArray, 0.95);
        return this.median;
    }

    public double getPercentile05() {
        return this.percentile05;
    }

    public double getPercentile95() {
        return this.percentile95;
    }

    private static double getQuartile(double[] dArray, double d) {
        double d2 = 0.0;
        int n = (int)(d * (double)dArray.length - 1.0);
        int n2 = (int)(d * (double)dArray.length);
        d2 = (dArray[n] + dArray[n2]) / 2.0;
        return d2;
    }

    public double getQuartile(double d) {
        double[] dArray = this.data.get();
        Arrays.sort(dArray);
        return StatisticsOverview.getQuartile(dArray, d);
    }

    public int getNumData() {
        return this.data.size();
    }

    public String toString() {
        if (this.data.size() == 0) {
            return "";
        }
        if (!this.evaluated) {
            this.evaluate();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name\t" + this.name);
        stringBuilder.append("\n");
        stringBuilder.append("Values\t" + this.data.size());
        stringBuilder.append("\n");
        stringBuilder.append("min\t" + this.min);
        stringBuilder.append("\n");
        stringBuilder.append("Mean\t" + DF3Plus.format(this.mean));
        stringBuilder.append("\n");
        stringBuilder.append("max\t" + this.max);
        stringBuilder.append("\n");
        stringBuilder.append("SDV\t" + DF3Plus.format(this.sdv));
        stringBuilder.append("\n");
        stringBuilder.append("Quartile 0.25\t" + DF3Plus.format(this.leftQuartile));
        stringBuilder.append("\n");
        stringBuilder.append("Median\t" + DF3Plus.format(this.median));
        stringBuilder.append("\n");
        stringBuilder.append("Quartile 0.75\t" + DF3Plus.format(this.rightQuartile));
        stringBuilder.append("\n");
        stringBuilder.append("Histogram values below hist min " + this.valsBelowHistMin + ", values above hist max " + this.valsAboveHistMax);
        stringBuilder.append("\n");
        stringBuilder.append(MatrixBasedHistogram.histogram2String(this.histogram, 2, 8));
        Matrix matrix = this.histogram.getTranspose();
        DecimalFormat decimalFormat = Matrix.format(2);
        stringBuilder.append("\n");
        for (int i = 0; i < matrix.rows(); ++i) {
            stringBuilder.append(Matrix.format(matrix.get(i, 0), decimalFormat, 8));
            stringBuilder.append("\t");
            stringBuilder.append(Matrix.format(matrix.get(i, 1), decimalFormat, 8));
            stringBuilder.append("\t");
            stringBuilder.append(Matrix.format(matrix.get(i, 2), decimalFormat, 8));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setBins(int n) {
        this.bins = n;
    }

    public int getValsBelowHistMin() {
        return this.valsBelowHistMin;
    }

    public int getValsAboveHistMax() {
        return this.valsAboveHistMax;
    }

    public Matrix getHistogram() {
        return this.histogram;
    }

    public static ModelStatisticsOverview get(DoubleArray doubleArray) {
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        return statisticsOverview.evaluate();
    }

    public static ModelStatisticsOverviewMedian getMedianOverview(DoubleArray doubleArray) {
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        statisticsOverview.evaluate();
        ModelStatisticsOverviewMedian modelStatisticsOverviewMedian = new ModelStatisticsOverviewMedian(statisticsOverview.percentile05, statisticsOverview.leftQuartile, statisticsOverview.median, statisticsOverview.rightQuartile, statisticsOverview.percentile95);
        return modelStatisticsOverviewMedian;
    }

    public static String toString(DoubleArray doubleArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        statisticsOverview.evaluate();
        stringBuilder.append(string);
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getMean()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getSdv()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getMedian()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getPercentile05()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getPercentile95()));
        return stringBuilder.toString();
    }

    public static String toString(IntArray intArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        DoubleArray doubleArray = new DoubleArray(intArray);
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        statisticsOverview.evaluate();
        stringBuilder.append(string);
        stringBuilder.append("\t");
        stringBuilder.append(DF1.format(statisticsOverview.getMean()));
        stringBuilder.append("\t");
        stringBuilder.append(DF1.format(statisticsOverview.getSdv()));
        stringBuilder.append("\t");
        stringBuilder.append(DF1.format(statisticsOverview.getMedian()));
        stringBuilder.append("\t");
        stringBuilder.append(DF1.format(statisticsOverview.getPercentile05()));
        stringBuilder.append("\t");
        stringBuilder.append(DF1.format(statisticsOverview.getPercentile95()));
        return stringBuilder.toString();
    }

    public static String toStringHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("text");
        stringBuilder.append("\t");
        stringBuilder.append("mean");
        stringBuilder.append("\t");
        stringBuilder.append("sdv");
        stringBuilder.append("\t");
        stringBuilder.append("median");
        stringBuilder.append("\t");
        stringBuilder.append("perc05");
        stringBuilder.append("\t");
        stringBuilder.append("perc95");
        return stringBuilder.toString();
    }

    public static String toString(DoubleArray doubleArray, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        statisticsOverview.evaluate();
        stringBuilder.append(string);
        stringBuilder.append("\t");
        stringBuilder.append(string2);
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getMean()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getSdv()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getMedian()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getPercentile05()));
        stringBuilder.append("\t");
        stringBuilder.append(DF3.format(statisticsOverview.getPercentile95()));
        return stringBuilder.toString();
    }
}

