/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.svm;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ModelError;
import com.actelion.research.calc.regression.knn.KNNRegression;
import com.actelion.research.calc.regression.svm.ParameterSVM;
import com.actelion.research.calc.regression.svm.SVMParameterHelper;
import com.actelion.research.calc.statistics.ModelStatisticsOverview;
import com.actelion.research.calc.statistics.StatisticsOverview;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.ModelXYIndex;
import org.machinelearning.svm.libsvm.svm_parameter;

public class AnalyticalParameterCalculatorSVM {
    public static ParameterSVM calculate(ModelXYIndex modelXYIndex) {
        System.out.println("AnalyticalParameterCalculatorSVM");
        if (modelXYIndex.Y.cols() != 1) {
            throw new RuntimeException("Only single col allowed for Y!");
        }
        double d = modelXYIndex.X.rows();
        System.out.println("Rows X train " + (int)d);
        DoubleArray doubleArray = new DoubleArray(modelXYIndex.Y.getColAsDouble(0));
        StatisticsOverview statisticsOverview = new StatisticsOverview(doubleArray);
        ModelStatisticsOverview modelStatisticsOverview = statisticsOverview.evaluate();
        double d2 = modelStatisticsOverview.sdv;
        System.out.println("Sigma in y " + Formatter.format3(d2));
        double d3 = modelStatisticsOverview.avr;
        System.out.println("Average in y " + Formatter.format3(d3));
        double d4 = Math.max(Math.abs(d3 - d2 * 3.0), Math.abs(d3 + d2 * 3.0));
        System.out.println("C " + Formatter.format3(d4));
        KNNRegression kNNRegression = new KNNRegression();
        kNNRegression.setNeighbours(3);
        Matrix matrix = kNNRegression.createModel(modelXYIndex);
        ModelError modelError = ModelError.calculateError(modelXYIndex.Y, matrix);
        double d5 = 1.0 / d * modelError.errSumSquared;
        System.out.println("Sigma squared y hat " + Formatter.format3(d5));
        double d6 = 3.0 * Math.sqrt(d5) * Math.sqrt(Math.log(d) / d);
        System.out.println("Epsilon " + Formatter.format3(d6));
        double d7 = 1.0 / (double)modelXYIndex.X.cols();
        System.out.println("Gamma " + Formatter.format4(d7));
        int n = 2;
        svm_parameter svm_parameter2 = SVMParameterHelper.regressionEpsilonSVR();
        svm_parameter2.kernel_type = n;
        svm_parameter2.eps = d6;
        svm_parameter2.C = d4;
        svm_parameter2.gamma = d7;
        svm_parameter2.degree = 0;
        ParameterSVM parameterSVM = new ParameterSVM(svm_parameter2);
        return parameterSVM;
    }
}

