/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.randomforest;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.randomforest.ParameterRandomForest;
import com.actelion.research.util.datamodel.ModelXYIndex;
import smile.regression.RandomForest;

public class RandomForestRegression
extends ARegressionMethod<ParameterRandomForest>
implements Comparable<RandomForestRegression> {
    public static final int MIN_NUM_VAR_SPLIT = 3;
    private RandomForest forest;

    public RandomForestRegression() {
        this.setParameterRegressionMethod(new ParameterRandomForest());
        try {
            System.setProperty("smile.threads", "1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RandomForestRegression(ParameterRandomForest parameterRandomForest) {
        this.setParameterRegressionMethod(parameterRandomForest);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        Matrix matrix = null;
        try {
            ParameterRandomForest parameterRandomForest = (ParameterRandomForest)this.getParameter();
            int n = (int)((double)modelXYIndex.X.cols() * parameterRandomForest.getFractionMTry() + 0.5);
            if (n < 3) {
                n = 3;
            }
            this.forest = new RandomForest(modelXYIndex.X.getArray(), modelXYIndex.Y.getColAsDouble(0), parameterRandomForest.getNumberOfTrees(), parameterRandomForest.getMaxNodes(), parameterRandomForest.getNodeSize(), n);
            matrix = this.calculateYHat(modelXYIndex.X);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return matrix;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        double[] dArray = new double[matrix.rows()];
        for (int i = 0; i < matrix.rows(); ++i) {
            double d;
            double[] dArray2 = matrix.getRow(i);
            dArray[i] = d = this.forest.predict(dArray2);
        }
        return new Matrix(false, dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double calculateYHat(double[] dArray) {
        double d;
        RandomForestRegression randomForestRegression = this;
        synchronized (randomForestRegression) {
            d = this.forest.predict(dArray);
        }
        return d;
    }

    @Override
    public int compareTo(RandomForestRegression randomForestRegression) {
        return ((ParameterRandomForest)this.getParameter()).compareTo((ParameterRegressionMethod)randomForestRegression.getParameter());
    }
}

