/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls.boxcox;

import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.linear.pls.ParameterPLS;
import java.text.DecimalFormat;
import java.util.List;

public class ParameterPLSBoxCox
extends ParameterPLS {
    public static final double LAMBDA = 0.4;
    public static final String TAG_LAMBDA = "Lambda";
    private double lambda;

    public ParameterPLSBoxCox() {
        super("PLS Power", 3);
        this.setLambda(0.4);
    }

    public ParameterPLSBoxCox(int n) {
        super("PLS Power", n);
    }

    public ParameterPLSBoxCox(ParameterPLSBoxCox parameterPLSBoxCox) {
        super(parameterPLSBoxCox);
        this.copy(parameterPLSBoxCox);
    }

    public void copy(ParameterPLSBoxCox parameterPLSBoxCox) {
        super.copy(parameterPLSBoxCox);
        this.setLambda(parameterPLSBoxCox.getLambda());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ParameterPLSBoxCox)) {
            return false;
        }
        boolean bl = super.equals(object);
        ParameterPLSBoxCox parameterPLSBoxCox = (ParameterPLSBoxCox)object;
        if (!MatrixFunctions.equals(this.getLambda(), parameterPLSBoxCox.getLambda())) {
            bl = false;
        }
        return bl;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        this.lambda = d;
        this.properties.put(TAG_LAMBDA, Double.toString(d));
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterPLSBoxCox parameterPLSBoxCox = (ParameterPLSBoxCox)parameterRegressionMethod;
        if (this.getFactors() > parameterPLSBoxCox.getFactors()) {
            n = 1;
        } else if (this.getFactors() < parameterPLSBoxCox.getFactors()) {
            n = -1;
        }
        if (n == 0) {
            if (this.lambda > parameterPLSBoxCox.lambda) {
                n = 1;
            } else if (this.lambda < parameterPLSBoxCox.lambda) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    protected void decodeProperties2Parameter() {
        this.factors = Integer.parseInt(this.properties.getProperty("Factors"));
        this.lambda = Double.parseDouble(this.properties.getProperty(TAG_LAMBDA));
    }

    @Override
    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        StringBuilder stringBuilder = new StringBuilder("ParameterPLSBoxCox{");
        stringBuilder.append("name=").append(this.getName());
        stringBuilder.append(", factors=").append(this.getFactors());
        stringBuilder.append(", lambda=").append(decimalFormat.format(this.lambda));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add("Factors");
        list.add(TAG_LAMBDA);
        return list;
    }
}

