/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls.boxcox;

import com.actelion.research.calc.BoxCox;
import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.linear.pls.PLSRegressionModelCalculator;
import com.actelion.research.calc.regression.linear.pls.boxcox.ParameterPLSBoxCox;
import com.actelion.research.util.datamodel.ModelXYColTags;
import com.actelion.research.util.datamodel.ModelXYIndex;

public class PLSBoxCoxY
extends PLSRegressionModelCalculator {
    public static final int FACTORS = 15;
    public static final double LAMBDA = 0.6;
    private BoxCox boxCox;

    public PLSBoxCoxY() {
        this.setParameterRegressionMethod(new ParameterPLSBoxCox(15));
        this.getParameter().setLambda(0.6);
        this.boxCox = new BoxCox(this.getParameter().getLambda());
    }

    public PLSBoxCoxY(ParameterPLSBoxCox parameterPLSBoxCox) {
        this.setParameterRegressionMethod(parameterPLSBoxCox);
        this.getParameter().setLambda(0.6);
        this.boxCox = new BoxCox(this.getParameter().getLambda());
    }

    public double getLambda() {
        return this.getParameter().getLambda();
    }

    public void setLambda(double d) {
        this.getParameter().setLambda(d);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        super.setCenterData(true);
        ModelXYColTags modelXYColTags = new ModelXYColTags();
        modelXYColTags.X = modelXYIndex.X;
        this.boxCox.setLambda(this.getParameter().getLambda());
        modelXYColTags.Y = BoxCox.transform(modelXYIndex.Y, this.boxCox);
        Matrix matrix = super.createModel(modelXYColTags);
        return matrix;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        Matrix matrix2 = super.calculateYHat(matrix);
        Matrix matrix3 = BoxCox.reTransform(matrix2, this.boxCox);
        return matrix3;
    }

    @Override
    public double calculateYHat(double[] dArray) {
        double d = super.calculateYHat(dArray);
        double d2 = this.boxCox.inverse(d);
        return d2;
    }

    @Override
    public ParameterPLSBoxCox getParameter() {
        return (ParameterPLSBoxCox)super.getParameter();
    }
}

