/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ModelError;
import com.actelion.research.calc.regression.linear.pls.PLSRegressionModelCalculator;
import com.actelion.research.calc.regression.linear.pls.SimPLSLMOValidation;
import com.actelion.research.util.datamodel.ModelXYIndex;

public class RegressionModelCalculatorOptimumFactors {
    private static final double FRACTION_LEAVE_OUT = 0.25;
    private static final int LMO_REPETITIONS = 7;
    private boolean centerData = false;
    private Matrix B;
    private Matrix YHat;
    private int factorsMin;

    public void setCenterData(boolean bl) {
        this.centerData = bl;
    }

    public ModelError calculateModel(ModelXYIndex modelXYIndex, int n, int n2) {
        SimPLSLMOValidation simPLSLMOValidation = new SimPLSLMOValidation(modelXYIndex.X, modelXYIndex.Y);
        simPLSLMOValidation.setFractionLeaveOut(0.25);
        simPLSLMOValidation.setNumRepetitions(7);
        double d = 2.147483647E9;
        this.factorsMin = 1;
        for (int i = n; i < n2 + 1; ++i) {
            simPLSLMOValidation.setNumFactors(i);
            double d2 = simPLSLMOValidation.calculateMedianTestError();
            if (!(d2 < d)) continue;
            d = d2;
            this.factorsMin = i;
        }
        System.out.println("Optimum number of factors " + this.factorsMin);
        PLSRegressionModelCalculator pLSRegressionModelCalculator = new PLSRegressionModelCalculator();
        pLSRegressionModelCalculator.setCenterData(this.centerData);
        pLSRegressionModelCalculator.setFactors(this.factorsMin);
        Matrix matrix = pLSRegressionModelCalculator.createModel(modelXYIndex);
        ModelError modelError = ModelError.calculateError(modelXYIndex.Y, matrix);
        this.B = pLSRegressionModelCalculator.getB();
        this.YHat = pLSRegressionModelCalculator.getYHat();
        return modelError;
    }

    public Matrix getB() {
        return this.B;
    }

    public Matrix getYHat() {
        return this.YHat;
    }

    public int getFactorsMin() {
        return this.factorsMin;
    }
}

