/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls;

import com.actelion.research.calc.regression.ParameterRegressionMethod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ParameterPLS
extends ParameterRegressionMethod {
    public static final int FACTORS = 3;
    public static final String TAG_FACTORS = "Factors";
    public static final boolean CENTER_DATA = true;
    protected int factors;
    private boolean centerData;

    public ParameterPLS() {
        super("PLS");
        this.setFactors(3);
        this.centerData = true;
    }

    public ParameterPLS(int n) {
        super("PLS");
        this.setFactors(n);
        this.centerData = true;
    }

    public ParameterPLS(ParameterPLS parameterPLS) {
        super(parameterPLS);
        this.copy(parameterPLS);
    }

    public void copy(ParameterPLS parameterPLS) {
        super.copy(parameterPLS);
        this.setFactors(parameterPLS.getFactors());
        this.setCenterData(parameterPLS.isCenterData());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ParameterPLS)) {
            return false;
        }
        boolean bl = true;
        ParameterPLS parameterPLS = (ParameterPLS)object;
        if (!this.getName().equals(parameterPLS.getName())) {
            bl = false;
        }
        if (this.getFactors() != parameterPLS.getFactors()) {
            bl = false;
        }
        return bl;
    }

    protected ParameterPLS(String string, int n) {
        super(string);
        this.setFactors(n);
        this.centerData = true;
    }

    public int getFactors() {
        return this.factors;
    }

    public void setFactors(int n) {
        this.factors = n;
        this.properties.put(TAG_FACTORS, Integer.toString(n));
    }

    public boolean isCenterData() {
        return this.centerData;
    }

    public void setCenterData(boolean bl) {
        this.centerData = bl;
    }

    @Override
    protected void decodeProperties2Parameter() {
        this.factors = Integer.parseInt(this.properties.getProperty(TAG_FACTORS));
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterPLS parameterPLS = (ParameterPLS)parameterRegressionMethod;
        if (this.factors > parameterPLS.factors) {
            n = 1;
        } else if (this.factors < parameterPLS.factors) {
            n = -1;
        }
        return n;
    }

    @Override
    public void read(File file) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileReader(file));
        String string = properties.getProperty("Name");
        if (!this.getName().equals(string)) {
            throw new RuntimeException("Name confusion!");
        }
        String string2 = properties.getProperty(TAG_FACTORS);
        this.factors = Integer.parseInt(string2);
        this.centerData = true;
    }

    @Override
    public void write(File file) throws IOException {
        Properties properties = new Properties();
        properties.put("Name", this.getName());
        properties.put(TAG_FACTORS, Integer.toString(this.factors));
        properties.store(new FileWriter(file), "");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ParameterPLS{");
        stringBuilder.append("name=").append(this.getName());
        stringBuilder.append(" factors=").append(this.factors);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add(TAG_FACTORS);
        return list;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File("/home/korffmo1/tmp/tmp00");
        File file2 = new File(file, "pls.properties");
        ParameterPLS parameterPLS = new ParameterPLS();
        parameterPLS.factors = 3;
        parameterPLS.write(file2);
        ParameterPLS parameterPLS2 = new ParameterPLS();
        parameterPLS2.read(file2);
        System.out.println(parameterPLS2.toString());
    }
}

