/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.knn;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.calc.SimilarityMulticore;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.knn.ParameterKNN;
import com.actelion.research.chem.descriptor.SimilarityCalculatorDoubleArray;
import com.actelion.research.util.datamodel.IdentifiedObject;
import com.actelion.research.util.datamodel.ModelXYIndex;
import java.util.ArrayList;
import java.util.List;

public class KNNRegression
extends ARegressionMethod<ParameterKNN> {
    public static final int NEIGHBOURS = 3;
    private static final double TINY = 1.0E-5;
    private SimilarityCalculatorDoubleArray similarityCalculatorDoubleArray;
    private SimilarityMulticore<double[]> similarityMulticore;
    private List<IdentifiedObject<double[]>> liXTrain;
    private Matrix XTrain;
    private Matrix YTrain;

    public KNNRegression() {
        this.setParameterRegressionMethod(new ParameterKNN(3));
        this.similarityCalculatorDoubleArray = new SimilarityCalculatorDoubleArray();
        this.similarityMulticore = new SimilarityMulticore<double[]>(this.similarityCalculatorDoubleArray);
    }

    public int getNeighbours() {
        return ((ParameterKNN)this.getParameter()).getNeighbours();
    }

    public void setNeighbours(int n) {
        ((ParameterKNN)this.getParameter()).setNeighbours(n);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        this.XTrain = modelXYIndex.X;
        this.YTrain = modelXYIndex.Y;
        this.liXTrain = MatrixFunctions.createIdentifiedObject(modelXYIndex.X);
        this.similarityMulticore.run(this.liXTrain, this.liXTrain);
        Matrix matrix = this.similarityMulticore.getSimilarityMatrix();
        Matrix matrix2 = KNNRegression.calculateYHat(matrix, this.YTrain, ((ParameterKNN)this.getParameter()).getNeighbours());
        return matrix2;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        List list = MatrixFunctions.createIdentifiedObject(matrix);
        this.similarityMulticore.run(this.liXTrain, list);
        Matrix matrix2 = this.similarityMulticore.getSimilarityMatrix();
        return KNNRegression.calculateYHat(matrix2, this.YTrain, ((ParameterKNN)this.getParameter()).getNeighbours());
    }

    @Override
    public double calculateYHat(double[] dArray) {
        int n = ((ParameterKNN)this.getParameter()).getNeighbours();
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        block0: for (int i = 0; i < this.liXTrain.size(); ++i) {
            IdentifiedObject<double[]> identifiedObject = this.liXTrain.get(i);
            double[] dArray3 = identifiedObject.getData();
            double d = this.similarityCalculatorDoubleArray.getSimilarity(dArray3, dArray);
            for (int j = n - 1; j >= 0; --j) {
                if (!(d > dArray2[j])) continue;
                dArray2[j] = d;
                nArray[j] = i;
                continue block0;
            }
        }
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            dArray4[i] = this.YTrain.get(n2, 0);
        }
        double d = KNNRegression.calculateYHat(dArray2, dArray4);
        return d;
    }

    private static Matrix calculateYHat(Matrix matrix, Matrix matrix2, int n) {
        int n2 = matrix.rows();
        int n3 = matrix.cols();
        int n4 = matrix2.cols();
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n3);
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>(n3);
        for (int i = 0; i < n3; ++i) {
            double[] dArray = new double[n];
            int[] nArray = new int[n];
            double d = 0.0;
            int n5 = 0;
            for (int j = 0; j < n2; ++j) {
                double d2 = matrix.get(j, i);
                if (!(d2 > d)) continue;
                dArray[n5] = d2;
                nArray[n5] = j;
                d = Double.MAX_VALUE;
                n5 = -1;
                for (int k = 0; k < dArray.length; ++k) {
                    if (!(dArray[k] < d)) continue;
                    d = dArray[k];
                    n5 = k;
                }
            }
            arrayList.add(dArray);
            arrayList2.add(nArray);
        }
        double[][] dArray = new double[n3][n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d;
                int[] nArray = (int[])arrayList2.get(j);
                double[] dArray2 = new double[n];
                for (int k = 0; k < nArray.length; ++k) {
                    dArray2[k] = matrix2.get(nArray[k], i);
                }
                dArray[j][i] = d = KNNRegression.calculateYHat((double[])arrayList.get(j), dArray2);
            }
        }
        return new Matrix(dArray);
    }

    private static double calculateYHat(double[] dArray, double[] dArray2) {
        double d;
        int n;
        double d2 = 0.0;
        double[] dArray3 = dArray;
        int n2 = dArray3.length;
        for (n = 0; n < n2; ++n) {
            d = dArray3[n];
            d2 += d;
        }
        double d3 = 0.0;
        if (d2 < 1.0E-5) {
            for (n = 0; n < dArray2.length; ++n) {
                d3 += dArray2[n];
            }
            d3 /= (double)dArray2.length;
        } else {
            for (n = 0; n < dArray2.length; ++n) {
                d = dArray[n];
                d3 += dArray2[n] * d;
            }
            d3 /= d2;
        }
        return d3;
    }
}

