/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.gaussianprocess;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.gaussianprocess.ParameterGaussianProcess;
import com.actelion.research.util.datamodel.ModelXYIndex;
import smile.clustering.KMeans;
import smile.math.Math;
import smile.math.kernel.GaussianKernel;

public class GaussianProcessRegression
extends ARegressionMethod<ParameterGaussianProcess>
implements Comparable<GaussianProcessRegression> {
    private static final int MIN_K = 3;
    private static final int K_DEVISOR = 10;
    private smile.regression.GaussianProcessRegression<double[]> gaussianProcessRegression;

    public GaussianProcessRegression() {
        this.setParameterRegressionMethod(new ParameterGaussianProcess());
        try {
            System.setProperty("smile.threads", "1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GaussianProcessRegression(ParameterGaussianProcess parameterGaussianProcess) {
        this.setParameterRegressionMethod(parameterGaussianProcess);
    }

    public void setLambda(double d) {
        ((ParameterGaussianProcess)this.getParameter()).setLambda(d);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        Matrix matrix = null;
        try {
            ParameterGaussianProcess parameterGaussianProcess = (ParameterGaussianProcess)this.getParameter();
            int n = modelXYIndex.X.rows();
            if (modelXYIndex.Y.cols() != 1) {
                throw new RuntimeException("Only one column for y is allowed!");
            }
            if (n < 3) {
                throw new RuntimeException("Unsufficient number of objects for regression.");
            }
            double[][] dArray = modelXYIndex.X.getArray();
            double[] dArray2 = modelXYIndex.Y.getColAsDouble(0);
            int n2 = n / 10;
            if (n > 1000) {
                n2 = n / 100;
            } else if (n > 10000) {
                n2 = n / 1000;
            }
            if (n2 < 3) {
                n2 = 3;
            }
            KMeans kMeans = new KMeans(dArray, n2, 10);
            double[][] dArray3 = kMeans.centroids();
            double d = 0.0;
            for (int i = 0; i < dArray3.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    d += Math.distance(dArray3[i], dArray3[j]);
                }
            }
            GaussianKernel gaussianKernel = new GaussianKernel(d /= (double)(2 * dArray3.length));
            this.gaussianProcessRegression = new smile.regression.GaussianProcessRegression<double[]>((T[])dArray, dArray2, gaussianKernel, parameterGaussianProcess.getLambda());
            matrix = this.calculateYHat(modelXYIndex.X);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return matrix;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        double[] dArray = new double[matrix.rows()];
        for (int i = 0; i < matrix.rows(); ++i) {
            double d;
            double[] dArray2 = matrix.getRow(i);
            dArray[i] = d = this.gaussianProcessRegression.predict(dArray2);
        }
        return new Matrix(false, dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double calculateYHat(double[] dArray) {
        double d;
        GaussianProcessRegression gaussianProcessRegression = this;
        synchronized (gaussianProcessRegression) {
            d = this.gaussianProcessRegression.predict(dArray);
        }
        return d;
    }

    @Override
    public int compareTo(GaussianProcessRegression gaussianProcessRegression) {
        return ((ParameterGaussianProcess)this.getParameter()).compareTo((ParameterRegressionMethod)gaussianProcessRegression.getParameter());
    }
}

