/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.gaussianprocess.GaussianProcessRegression;
import com.actelion.research.calc.regression.knn.KNNRegression;
import com.actelion.research.calc.regression.linear.pls.PLSRegressionModelCalculator;
import com.actelion.research.calc.regression.linear.pls.boxcox.PLSBoxCoxY;
import com.actelion.research.calc.regression.median.MedianRegression;
import com.actelion.research.calc.regression.neuralnetwork.NeuralNetworkRegression;
import com.actelion.research.calc.regression.randomforest.RandomForestRegression;
import com.actelion.research.calc.regression.svm.SVMRegression;
import com.actelion.research.util.datamodel.ModelXYIndex;

public class RegressionMethodContainer {
    private ARegressionMethod regressionMethod;
    private MedianRegression calculatorMedianRegression = new MedianRegression();
    private PLSRegressionModelCalculator calculatorPLS = new PLSRegressionModelCalculator();
    private PLSBoxCoxY calculatorPLSBoxCox = new PLSBoxCoxY();
    private KNNRegression calculatorKNNRegression = new KNNRegression();
    private SVMRegression calculatorSVMRegression = new SVMRegression();
    private RandomForestRegression randomForestRegression = new RandomForestRegression();
    private GaussianProcessRegression gaussianProcessRegression = new GaussianProcessRegression();
    private NeuralNetworkRegression neuralNetworkRegression = new NeuralNetworkRegression();

    public RegressionMethodContainer() {
        this.regressionMethod = this.calculatorPLS;
    }

    public MedianRegression getMedian() {
        return this.calculatorMedianRegression;
    }

    public PLSRegressionModelCalculator getPLS() {
        return this.calculatorPLS;
    }

    public PLSBoxCoxY getPLSBoxCox() {
        return this.calculatorPLSBoxCox;
    }

    public KNNRegression getKNN() {
        return this.calculatorKNNRegression;
    }

    public SVMRegression getSVM() {
        return this.calculatorSVMRegression;
    }

    public RandomForestRegression getRandomForestRegression() {
        return this.randomForestRegression;
    }

    public GaussianProcessRegression getGaussianProcessRegression() {
        return this.gaussianProcessRegression;
    }

    public NeuralNetworkRegression getNeuralNetworkRegression() {
        return this.neuralNetworkRegression;
    }

    public Matrix createModel(ModelXYIndex modelXYIndex) {
        return this.regressionMethod.createModel(modelXYIndex);
    }

    public Matrix calculateYHat(Matrix matrix) {
        return this.regressionMethod.calculateYHat(matrix);
    }

    public void setMethod(String string) {
        if (this.calculatorMedianRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.calculatorMedianRegression;
        } else if (this.calculatorKNNRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.calculatorKNNRegression;
        } else if (this.calculatorPLSBoxCox.getName().equals(string.trim())) {
            this.regressionMethod = this.calculatorPLSBoxCox;
        } else if (this.calculatorPLS.getName().equals(string.trim())) {
            this.regressionMethod = this.calculatorPLS;
        } else if (this.calculatorSVMRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.calculatorSVMRegression;
        } else if (this.randomForestRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.randomForestRegression;
        } else if (this.gaussianProcessRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.gaussianProcessRegression;
        } else if (this.neuralNetworkRegression.getName().equals(string.trim())) {
            this.regressionMethod = this.neuralNetworkRegression;
        } else {
            this.regressionMethod = this.calculatorPLS;
            System.err.println("RegressionMethodFactory setMethod unknown model " + string + " set to " + this.calculatorPLS.getName());
        }
    }

    public ARegressionMethod getRegressionMethod() {
        return this.regressionMethod;
    }

    public ARegressionMethod getRegressionMethod(String string) {
        this.setMethod(string);
        return this.regressionMethod;
    }

    public static ARegressionMethod createRegressionMethod(String string) {
        ARegressionMethod aRegressionMethod = null;
        if ("Median".equals(string.trim())) {
            aRegressionMethod = new MedianRegression();
        } else if ("KNN regression".equals(string.trim())) {
            aRegressionMethod = new KNNRegression();
        } else if ("PLS".equals(string.trim())) {
            aRegressionMethod = new PLSRegressionModelCalculator();
        } else if ("PLS Power".equals(string.trim())) {
            aRegressionMethod = new PLSBoxCoxY();
        } else if ("SVM regression".equals(string.trim())) {
            aRegressionMethod = new SVMRegression();
        } else if ("Random Forest regression".equals(string.trim())) {
            aRegressionMethod = new RandomForestRegression();
        } else if ("Gaussian process regression".equals(string.trim())) {
            aRegressionMethod = new GaussianProcessRegression();
        } else if ("Neural network regression".equals(string.trim())) {
            aRegressionMethod = new NeuralNetworkRegression();
        } else {
            throw new RuntimeException("Unknown regression type '" + string + "'.");
        }
        return aRegressionMethod;
    }

    public static ARegressionMethod createRegressionMethod(ParameterRegressionMethod parameterRegressionMethod) {
        ARegressionMethod aRegressionMethod = RegressionMethodContainer.createRegressionMethod(parameterRegressionMethod.getName());
        aRegressionMethod.setParameterRegressionMethod(parameterRegressionMethod);
        return aRegressionMethod;
    }
}

