/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.histogram;

import java.util.List;
import java.util.Random;

public class IntegerHistogram {
    public static final int[][] ARR_BINS_EXAMPLE = new int[][]{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 8}, {8, 10}, {10, 20}, {20, 50}, {50, 100}, {100, 1000}};
    private int[][] arrBins;
    private int[] arrCounts;

    public IntegerHistogram(int[][] nArray) {
        this(nArray, true);
    }

    public IntegerHistogram(int[][] nArray, boolean bl) {
        this.arrBins = nArray;
        this.arrCounts = new int[nArray.length];
        if (bl) {
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i - 1][1] == nArray[i][0]) continue;
                throw new RuntimeException("Non consecutive bins!");
            }
        }
    }

    public void add(int n) {
        for (int i = 0; i < this.arrBins.length; ++i) {
            if (n < this.arrBins[i][0] || n >= this.arrBins[i][1]) continue;
            int n2 = i;
            this.arrCounts[n2] = this.arrCounts[n2] + 1;
        }
    }

    public void add(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
    }

    public void add(List<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
    }

    public int getTotalCounts() {
        int n = 0;
        for (int i = 0; i < this.arrBins.length; ++i) {
            n += this.arrCounts[i];
        }
        return n;
    }

    public int[] getBinWithNPercentOfAllCounts(int n) {
        int n2 = this.getTotalCounts();
        int n3 = (int)((double)n2 * ((double)n / 100.0));
        int n4 = 0;
        int n5 = -1;
        for (int i = 0; i < this.arrBins.length; ++i) {
            if ((n4 += this.arrCounts[i]) < n3) continue;
            n5 = i;
            break;
        }
        int[] nArray = new int[]{this.arrBins[n5][0], this.arrBins[n5][1]};
        return nArray;
    }

    public String toString() {
        StringBuilder stringBuilder;
        String string;
        int n;
        String string2 = "\t";
        int[] nArray = new int[this.arrCounts.length];
        for (int i = 0; i < this.arrBins.length; ++i) {
            n = this.arrCounts[i];
            if (this.arrBins[i][0] > n) {
                n = this.arrBins[i][0];
            }
            if (this.arrBins[i][1] > n) {
                n = this.arrBins[i][1];
            }
            string = Integer.toString(n);
            nArray[i] = string.length() + 1;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (n = 0; n < this.arrBins.length; ++n) {
            string = Integer.toString(this.arrBins[n][0]);
            stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() < nArray[n]) {
                stringBuilder.append(" ");
            }
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        stringBuilder2.append("\n");
        for (n = 0; n < this.arrBins.length; ++n) {
            string = Integer.toString(this.arrBins[n][1]);
            stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() < nArray[n]) {
                stringBuilder.append(" ");
            }
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        stringBuilder2.append("\n");
        for (n = 0; n < this.arrCounts.length; ++n) {
            string = Integer.toString(this.arrCounts[n]);
            stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() < nArray[n]) {
                stringBuilder.append(" ");
            }
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        return stringBuilder2.toString();
    }

    public static void main(String[] stringArray) {
        int n = 10000;
        int n2 = 1000;
        int n3 = 20;
        int[][] nArray = IntegerHistogram.getBinsEquallyDistributed(n3, n2);
        IntegerHistogram integerHistogram = new IntegerHistogram(nArray);
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            integerHistogram.add(random.nextInt(n2));
        }
        System.out.println(integerHistogram.toString());
    }

    public static int[][] getBinsEquallyDistributed(int n, int n2) {
        return IntegerHistogram.getBinsEquallyDistributed(n, 0, n2);
    }

    public static int[][] getBinsEquallyDistributed(int n, int n2, int n3) {
        int n4 = (n3 - n2) / n;
        if (n > n3 - n2) {
            n4 = 1;
            n = n3 - n2 + 1;
        }
        int[][] nArrayArray = new int[n][];
        int n5 = n2;
        for (int i = 0; i < n; ++i) {
            int n6 = n5 + n4;
            int[] nArray = new int[]{n5, n6};
            n5 = n6;
            nArrayArray[i] = nArray;
        }
        if (nArrayArray[nArrayArray.length - 1][1] <= n3) {
            nArrayArray[nArrayArray.length - 1][1] = n3 + 1;
        }
        return nArrayArray;
    }
}

