/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.filter;

import com.actelion.research.util.ArrayUtils;

public class SlidingWindow {
    private double[] arrFilter;
    private int l;
    private int l_half;

    public SlidingWindow(double[] dArray) {
        this.arrFilter = dArray;
        if (dArray.length % 2 == 0) {
            throw new RuntimeException("Odd number of filter values needed.");
        }
        this.l = dArray.length;
        this.l_half = dArray.length / 2;
    }

    public double[] filter(double[] dArray) {
        double[] dArray2 = new double[dArray.length + this.l * 2];
        double[] dArray3 = new double[dArray.length + this.l * 2];
        System.arraycopy(dArray, 0, dArray2, this.l, dArray.length);
        int n = dArray2.length - this.l_half;
        for (int i = this.l_half; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.arrFilter.length; ++j) {
                int n2 = i - this.l_half + j;
                d += dArray2[n2] * this.arrFilter[j] + 0.5;
            }
            dArray3[i] = d;
        }
        dArray2 = new double[dArray.length];
        System.arraycopy(dArray3, this.l, dArray2, 0, dArray2.length);
        return dArray2;
    }

    public int[] filter(int[] nArray) {
        int[] nArray2 = new int[nArray.length + this.l * 2];
        int[] nArray3 = new int[nArray.length + this.l * 2];
        System.arraycopy(nArray, 0, nArray2, this.l, nArray.length);
        int n = nArray2.length - this.l_half;
        for (int i = this.l_half; i < n; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.arrFilter.length; ++j) {
                int n3 = i - this.l_half + j;
                n2 += (int)((double)nArray2[n3] * this.arrFilter[j] + 0.5);
            }
            nArray3[i] = n2;
        }
        nArray2 = new int[nArray.length];
        System.arraycopy(nArray3, this.l, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public byte[] filter(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + this.l * 2];
        byte[] byArray3 = new byte[byArray.length + this.l * 2];
        System.arraycopy(byArray, 0, byArray2, this.l, byArray.length);
        int n = byArray2.length - this.l_half;
        for (int i = this.l_half; i < n; ++i) {
            byte by = 0;
            for (int j = 0; j < this.arrFilter.length; ++j) {
                int n2 = i - this.l_half + j;
                by = (byte)(by + (byte)((double)byArray2[n2] * this.arrFilter[j] + 0.5));
            }
            byArray3[i] = by;
        }
        byArray2 = new byte[byArray.length];
        System.arraycopy(byArray3, this.l, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{0, 0, 0, 0, 100, 100, 0, 0, 0, 0, 0};
        double[] dArray = new double[]{0.25, 0.5, 0.25};
        SlidingWindow slidingWindow = new SlidingWindow(dArray);
        int[] nArray2 = slidingWindow.filter(nArray);
        System.out.println(ArrayUtils.toString(nArray2));
    }
}

