/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.INumericalDataColumn;
import java.util.Arrays;

public class CorrelationCalculator {
    public static final String[] TYPE_LONG_NAME = new String[]{"Bravais-Pearson (linear correlation)", "Spearman (correlation of ranks)"};
    public static final String[] TYPE_NAME = new String[]{"Bravais-Pearson", "Spearman"};
    public static final String[] TYPE_CODE = new String[]{"bravais-pearson", "spearman"};
    public static final int TYPE_NONE = -1;
    public static final int TYPE_BRAVAIS_PEARSON = 0;
    public static final int TYPE_SPEARMAN = 1;
    private int mValueCount;
    private int[][] mValueCountMatrix;

    public double calculateCorrelation(INumericalDataColumn iNumericalDataColumn, INumericalDataColumn iNumericalDataColumn2, int n) {
        int n2 = iNumericalDataColumn.getValueCount();
        if (n2 != iNumericalDataColumn2.getValueCount()) {
            return Double.NaN;
        }
        double d = Double.NaN;
        if (n == 0) {
            this.mValueCount = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d4 = iNumericalDataColumn.getValueAt(i);
                double d5 = iNumericalDataColumn2.getValueAt(i);
                if (Double.isNaN(d4) || Double.isNaN(d5)) continue;
                d2 += d4;
                d3 += d5;
                ++this.mValueCount;
            }
            if (this.mValueCount < 2) {
                return Double.NaN;
            }
            d2 /= (double)this.mValueCount;
            d3 /= (double)this.mValueCount;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d9 = iNumericalDataColumn.getValueAt(i);
                double d10 = iNumericalDataColumn2.getValueAt(i);
                if (Double.isNaN(d9) || Double.isNaN(d10)) continue;
                double d11 = d9 - d2;
                double d12 = d10 - d3;
                d6 += d11 * d11;
                d7 += d11 * d12;
                d8 += d12 * d12;
            }
            d = d7 / Math.sqrt(d6 * d8);
        } else if (n == 1) {
            int n3;
            if (n2 < 2) {
                return Double.NaN;
            }
            this.mValueCount = 0;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[this.mValueCount] = iNumericalDataColumn.getValueAt(n3);
                dArray2[this.mValueCount] = iNumericalDataColumn2.getValueAt(n3);
                if (Double.isNaN(dArray[this.mValueCount]) || Double.isNaN(dArray2[this.mValueCount])) continue;
                ++this.mValueCount;
            }
            for (n3 = this.mValueCount; n3 < n2; ++n3) {
                dArray[n3] = Double.NaN;
                dArray2[n3] = Double.NaN;
            }
            Arrays.sort(dArray);
            Arrays.sort(dArray2);
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = (double)(this.mValueCount + 1) / 2.0;
            for (int i = 0; i < n2; ++i) {
                if (Double.isNaN(iNumericalDataColumn.getValueAt(i)) || Double.isNaN(iNumericalDataColumn2.getValueAt(i))) continue;
                double d17 = this.getPosition(dArray, iNumericalDataColumn.getValueAt(i));
                double d18 = this.getPosition(dArray2, iNumericalDataColumn2.getValueAt(i));
                double d19 = d17 - d16;
                double d20 = d18 - d16;
                d13 += d19 * d19;
                d14 += d19 * d20;
                d15 += d20 * d20;
            }
            d = d14 / Math.sqrt(d13 * d15);
        }
        return d;
    }

    public int getValueCount() {
        return this.mValueCount;
    }

    public int[][] getValueCountMatrix() {
        return this.mValueCountMatrix;
    }

    public double[][] calculateMatrix(INumericalDataColumn[] iNumericalDataColumnArray, int n) {
        double[][] dArrayArray = new double[iNumericalDataColumnArray.length][];
        this.mValueCountMatrix = new int[iNumericalDataColumnArray.length][];
        for (int i = 1; i < iNumericalDataColumnArray.length; ++i) {
            dArrayArray[i] = new double[i];
            this.mValueCountMatrix[i] = new int[i];
            for (int j = 0; j < i; ++j) {
                dArrayArray[i][j] = this.calculateCorrelation(iNumericalDataColumnArray[i], iNumericalDataColumnArray[j], n);
                this.mValueCountMatrix[i][j] = this.mValueCount;
            }
        }
        return dArrayArray;
    }

    private double getPosition(double[] dArray, double d) {
        int n;
        int n2;
        int n3;
        for (n3 = n2 = Arrays.binarySearch(dArray, d); n3 > 0 && dArray[n3 - 1] == d; --n3) {
        }
        for (n = n2; n < dArray.length - 1 && dArray[n + 1] == d; ++n) {
        }
        return (double)(n3 + n) / 2.0 + 1.0;
    }
}

