#!/bin/bash
#PBS -N portal_job_00006989
#PBS -q express
#PBS -P exp-00049
#PBS -lselect=1:ncpus=256:mem=900gb
#PBS -lwalltime=72:0:0
export NCORES=128
export MEMORY_GB=200

set -e

echo "HOST: $(hostname)"
echo "Job ID: $PBS_JOBID"
cd "$PBS_O_WORKDIR"

(while true; do echo "$SECONDS" > WALLTIME; sleep 5s; done) &

export GAUSS_SCRDIR=$EPHEMERAL/$PBS_JOBID/
mkdir -p $GAUSS_SCRDIR

module load gaussian/g16-c01-avx
[[ "" != "" ]] && unfchk ""
chk_name=$(/apps/ood/portal_config/portal_scripts/prep_gaussian.sh "IRC.gjf" "")
g16 "IRC.gjf"
formchk "$chk_name" && rm -f "$chk_name"
/apps/ood/portal_config/portal_scripts/publish_gaussian.sh "IRC.gjf" "$chk_name"

