#!/bin/bash
#PBS -N portal_job_00006865
#PBS -l select=1:ncpus=16:mem=48gb,walltime=72:00:00
export NCORES=16
export MEMORY_GB=48


set -e

echo "HOST: $(hostname)"
echo "Job ID: $PBS_JOBID"
cd "$PBS_O_WORKDIR"

(while true; do echo "$SECONDS" > WALLTIME; sleep 5s; done) &

export GAUSS_SCRDIR=$EPHEMERAL/$PBS_JOBID/
mkdir -p $GAUSS_SCRDIR

module load gaussian/g16-c01-avx
[[ "" != "" ]] && unfchk ""
chk_name=$(/apps/ood/portal_config/portal_scripts/prep_gaussian.sh "Amine-svpp.gjf" "")
g16 "Amine-svpp.gjf"
formchk "$chk_name" && rm -f "$chk_name"
/apps/ood/portal_config/portal_scripts/publish_gaussian.sh "Amine-svpp.gjf" "$chk_name"

