rm(list=ls())


Values <- read.table("alkene.txt", header=TRUE)
Values_F <- read.table("alkene_ferrocene.txt", header=TRUE)


P <- Values[,1]
P_F <- Values_F[,1]
S_one <- Values[,2]*1000000
S_two <- Values[,3]*1000000
S_three <- Values[,4]*1000000
F_one <- Values_F[,5]*1000000
F_two <- Values_F[,6]*1000000
F_three <- Values_F[,7]*1000000

par(mfrow=c(1,2), mar = c(2.5,3,0,0))
#par(mar = c(0.5,3,0,0))
plot(P, S_one, col="red", xlab="", ylab=expression(paste("Current / ", mu ,"A")), ylim=c(-30,100),mgp=c(1.5,1,0), xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)
at1=seq(-3,3,1)
at11=seq(-2.5,2.5,1)
at111=seq(-3.2,3.2,0.01)
at2=seq(-20,100,20)
at22=seq(-10,90,20)
at222=seq(-30,100,0.1)
at3=seq(-3,3,1)
at33=seq(-2.5,2.5,1)
at333=seq(-3.2,3.2,0.01)
at4=seq(0,100,20)
at444=seq(-30,100,0.1)
axis(1,at=at1,pos=-30,labels=TRUE,tck=0.02,mgp=c(0,0.1,0))
axis(1,at=at11,pos=-30,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(1,at=at111,pos=-30,labels=NA,tck=0,mgp=c(0,0.1,0))
axis(2,at=at2,pos=-3.2,labels=TRUE,tck=0.02,mgp=c(0,0.3,0))
axis(2,at=at22,pos=-3.2,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(2,at=at222,pos=-3.2,labels=NA,tck=0,mgp=c(0,0.3,0))
axis(3,at=at3,pos=100,labels=NA,tck=0.02,mgp=c(0,0.1,0))
axis(3,at=at33,pos=100,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(3,at=at333,pos=100,labels=NA,tck=0,mgp=c(0,0.1,0))
axis(4,at=at2,pos=3.2,labels=NA,tck=0.02,mgp=c(0,0.3,0))
axis(4,at=at222,pos=3.2,labels=NA,tck=0,mgp=c(0,0.3,0))
axis(4,at=at22,pos=3.2,labels=NA,tck=0.01,mgp=c(0,0.1,0))
#axis(2,pos=0,labels=NA,tck=0)
#axis(3,pos=0.4,labels=NA,tck=0)
mtext(text="Potential / V", side=1, line=1.2)
par(new=TRUE)
plot(P, S_two, col="black", xlab="", ylab="", ylim=c(-30,100), mgp=c(1.2,1,0),xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)
par(new=TRUE)
plot(P, S_three, col="deepskyblue4", xlab="", ylab="", ylim=c(-30,100), mgp=c(1.2,1,0),xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)

legend(-2.4,90,c("Scan 1", "Scan 2","Scan 3"),pch=c(16,16,16), col=c("red","black","deepskyblue4"), bty="n",y.intersp=1.5)

#Plot with ferrocene

plot(P_F, F_one, col="red", xlab="", ylab="", ylim=c(-30,100),mgp=c(1.5,1,0), xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)
at1=seq(-3,3,1)
at11=seq(-2.5,2.5,1)
at111=seq(-3.2,3.2,0.01)
at2=seq(-20,100,20)
at22=seq(-10,90,20)
at222=seq(-30,100,0.1)
at3=seq(-3,3,1)
at33=seq(-2.5,2.5,1)
at333=seq(-3.2,3.2,0.01)
at4=seq(0,100,20)
at444=seq(-30,100,0.1)
axis(1,at=at1,pos=-30,labels=TRUE,tck=0.02,mgp=c(0,0.1,0))
axis(1,at=at11,pos=-30,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(1,at=at111,pos=-30,labels=NA,tck=0,mgp=c(0,0.1,0))
axis(2,at=at2,pos=-3.2,labels=TRUE,tck=0.02,mgp=c(0,0.3,0))
axis(2,at=at22,pos=-3.2,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(2,at=at222,pos=-3.2,labels=NA,tck=0,mgp=c(0,0.3,0))
axis(3,at=at3,pos=100,labels=NA,tck=0.02,mgp=c(0,0.1,0))
axis(3,at=at33,pos=100,labels=NA,tck=0.01,mgp=c(0,0.1,0))
axis(3,at=at333,pos=100,labels=NA,tck=0,mgp=c(0,0.1,0))
axis(4,at=at2,pos=3.2,labels=NA,tck=0.02,mgp=c(0,0.3,0))
axis(4,at=at222,pos=3.2,labels=NA,tck=0,mgp=c(0,0.3,0))
axis(4,at=at22,pos=3.2,labels=NA,tck=0.01,mgp=c(0,0.1,0))
#axis(2,pos=0,labels=NA,tck=0)
#axis(3,pos=0.4,labels=NA,tck=0)
mtext(text="Potential / V", side=1, line=1.2)
par(new=TRUE)
plot(P_F, F_two, col="black", xlab="", ylab="", ylim=c(-30,100), mgp=c(1.2,1,0),xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)
par(new=TRUE)
plot(P_F, F_three, col="deepskyblue4", xlab="", ylab="", ylim=c(-30,100), mgp=c(1.2,1,0),xlim=c(-3.2,3.2), lab=c(6,10,7), axes=FALSE,
pch=16,
cex=0.7)

legend(-2.4,90,c("Scan 1", "Scan 2","Scan 3"),pch=c(16,16,16), col=c("red","black","deepskyblue4"), bty="n",y.intersp=1.5)

dev.copy2pdf(file="alkene.pdf",height=5,width=7)
