function [L] = likelihood(data, theta, neg_params)
% A function for calculating the likelihood of the data points given a fixed set of parameter values
% 
% Assuming that the discrepency between the data and the model (with given parameters) is a normally distributed random variable

% Predict equilibirum amount adsorbed using isotherm model with given
% combination of uncertain parameters
theta(1:end-1) = theta(1:end-1).*neg_params';
q_eq_model = isotherm(theta(1:end-1), [data(:, 1)*1e+5, data(:, 3)]);

% Calculate likelihood
sig = theta(end); % Standard deviation of residuals
nq = size(data, 1); % Number of experimental data points
q_eq_exp = data(:, 2); % Equilibrium amount adsorbed
L = (1/((sqrt(2*pi)*sig)^nq))*exp(-sum((q_eq_exp - q_eq_model).^2)/(2*(sig^2))); % Likelihood

end