function [q1, RSS] = isotherm_outputs(parameters, isotherm_pred, experiment_temps, P, neg_params)
% A sub-fuction for evaluating the dual-site Langmuir model at a given set of model parameters, as well
% as the residual sum of squares between the isotherm predictions and the nominal isotherm predictions

parameters = parameters.*neg_params';

for i = 1:length(experiment_temps)
	T = experiment_temps(i);
	q1(i, :) = isotherm(parameters, [P', ones(length(P), 1).*T])';
end

RSS = 0;
for i = 1:length(experiment_temps)
	RSS = RSS + sum((isotherm_pred(i, :) - q1(i, :)).^2);
end

q1 = q1';

end