function [q] = isotherm(params, x)

p = x(:, 1); % Pressure [Pa]
T = x(:, 2); % Temperature [K]
R = 8.314; % Universal gas constant [J/mol/K]



%%
%========================================
%========== USER ISOTHERM HERE ==========
%========================================
%
% User defined isotherm goes here.
%
% The parameters of the isotherm model are unpacked from the vector
% "params". The order of the parameters inside params is the same as that
% defined in x0 (main code).
%
% The isotherm function needs to evaluate the equilibrium at all (P, T)
% points defined by the conditions stored in the vectors p and T.
%
% The isotherm function needs to return the equilibrium amount adsorbed
% [mol/kg] at each of these (P, T) points in a corresponding column vector.

% e.g. single-site Langmuir model

qs = params(1); % Saturation loading [mol/kg]
b0 = params(2); % Reference equilibrium constant [m3/mol]
dU = params(3); % Heat of adsorption [J/mol]

b = b0.*exp(-dU./(R.*T)); % Langmuir constant for site 1
for j = 1:size(p, 1)
	c(j) = p(j)/R/T(j); % Molar concentration of gas phase [mol/m3]
	q(j) = qs*(b(j)*c(j))/(1 + (b(j)*c(j))); % Equilibrium amount adsorbed of component 1 [mol/kg]
end

q = q';

end