function [sol] = fit_distribution(bin_edges, y)
% A function for fitting a Normal PDF to histrogram data

% Calculate bin centroid locations
x = zeros(1, length(bin_edges) - 1); % Bin centroid locations
for i = 2:length(bin_edges)
	x(i-1) = mean([bin_edges(i), bin_edges(i-1)]);
end

% Find parameters of skewed Normal distribution
x0 = [x(round(end/2))]; % Inital point (location, scale, shape)
lb = [min(x)]; % Lower bound (location, scale, shape)
ub = [max(x)]; % Upper bound (location, scale, shape)

% Solver: lsqcurvefit
options = optimoptions('lsqcurvefit', 'Display', 'off');
sol = lsqcurvefit(@exponential_pdf, x0, x, y, lb, ub, options);



% Residual between Normal PDF and data (residual sum of squares)
function [RSS] = exponential_residual(params, x, y)

% Unpack parameter values	
mu = params(1); % Mean

% Caluclate vector of exponential PDF values (f)
f = (1/mu)*exp(-x./mu);

% Calculate residual sum of squares between skewed-normal and marginal posterior
RSS = sum((f - y).^2); % Residual sum of squares

end


% Skewed normal PDF values
function [f] = exponential_pdf(params, x)

% Unpack parameter values	
mu = params(1); % Location parameter

% Caluclate vector of skew-normal PDF values (f)
f = (1/mu)*exp(-x/mu);

end

end